/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.api.impl;

import io.xpipe.api.DataSource;
import io.xpipe.api.DataSourceConfig;
import io.xpipe.api.connector.XPipeApiConnection;
import io.xpipe.api.impl.DataRawImpl;
import io.xpipe.api.impl.DataStructureImpl;
import io.xpipe.api.impl.DataTableImpl;
import io.xpipe.api.impl.DataTextImpl;
import io.xpipe.beacon.RequestMessage;
import io.xpipe.beacon.exchange.AddSourceExchange;
import io.xpipe.beacon.exchange.ForwardExchange;
import io.xpipe.beacon.exchange.QueryDataSourceExchange;
import io.xpipe.beacon.exchange.ReadExchange;
import io.xpipe.beacon.exchange.WriteStreamExchange;
import io.xpipe.core.dialog.DialogReference;
import io.xpipe.core.impl.InternalStreamStore;
import io.xpipe.core.source.DataSourceReference;
import io.xpipe.core.source.DataSourceType;
import io.xpipe.core.source.DataStoreId;
import io.xpipe.core.store.DataStore;
import io.xpipe.core.store.StreamDataStore;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class DataSourceImpl
implements DataSource {
    private final DataStoreId sourceId;
    private final DataSourceConfig config;
    private final io.xpipe.core.source.DataSource<?> internalSource;

    public DataSourceImpl(DataStoreId sourceId, DataSourceConfig config, io.xpipe.core.source.DataSource<?> internalSource) {
        this.sourceId = sourceId;
        this.config = config;
        this.internalSource = internalSource;
    }

    public static DataSource get(DataSourceReference ds) {
        return XPipeApiConnection.execute(con -> {
            QueryDataSourceExchange.Request req = QueryDataSourceExchange.Request.builder().ref(ds).build();
            QueryDataSourceExchange.Response res = (QueryDataSourceExchange.Response)con.performSimpleExchange((RequestMessage)req);
            DataSourceConfig config = new DataSourceConfig(res.getProvider(), res.getConfig());
            return switch (res.getType()) {
                case DataSourceType.TABLE -> new DataTableImpl(res.getId(), config, res.getInternalSource());
                case DataSourceType.STRUCTURE -> new DataStructureImpl(res.getId(), config, res.getInternalSource());
                case DataSourceType.TEXT -> new DataTextImpl(res.getId(), config, res.getInternalSource());
                case DataSourceType.RAW -> new DataRawImpl(res.getId(), config, res.getInternalSource());
                case DataSourceType.COLLECTION -> throw new UnsupportedOperationException("Unimplemented case: " + String.valueOf(res.getType()));
                default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(res.getType()));
            };
        });
    }

    public static DataSource create(DataStoreId id, io.xpipe.core.source.DataSource<?> source) {
        AddSourceExchange.Request startReq = AddSourceExchange.Request.builder().source(source).target(id).build();
        DataStoreId returnedId = XPipeApiConnection.execute(con -> {
            AddSourceExchange.Response r = (AddSourceExchange.Response)con.performSimpleExchange((RequestMessage)startReq);
            return r.getId();
        });
        DataSourceReference ref = DataSourceReference.id((DataStoreId)returnedId);
        return DataSourceImpl.get(ref);
    }

    public static DataSource create(DataStoreId id, String type, DataStore store) {
        StreamDataStore s;
        if (store instanceof StreamDataStore && (s = (StreamDataStore)store).isContentExclusivelyAccessible()) {
            store = (DataStore)XPipeApiConnection.execute(con -> {
                InternalStreamStore internal = con.createInternalStreamStore();
                WriteStreamExchange.Request req = WriteStreamExchange.Request.builder().name(internal.getUuid().toString()).build();
                con.performOutputExchange((RequestMessage)req, out -> {
                    try (InputStream inputStream = s.openInput();){
                        inputStream.transferTo((OutputStream)out);
                    }
                });
                return internal;
            });
        }
        ReadExchange.Request startReq = ReadExchange.Request.builder().provider(type).store(store).target(id).configureAll(false).build();
        ReadExchange.Response startRes = XPipeApiConnection.execute(con -> (ReadExchange.Response)con.performSimpleExchange((RequestMessage)startReq));
        DialogReference configInstance = startRes.getConfig();
        XPipeApiConnection.finishDialog(configInstance);
        DataSourceReference ref = id != null ? DataSourceReference.id((DataStoreId)id) : DataSourceReference.latest();
        return DataSourceImpl.get(ref);
    }

    public static DataSource create(DataStoreId id, String type, InputStream in) {
        InternalStreamStore store = XPipeApiConnection.execute(con -> {
            InternalStreamStore internal = con.createInternalStreamStore();
            WriteStreamExchange.Request req = WriteStreamExchange.Request.builder().name(internal.getUuid().toString()).build();
            con.performOutputExchange((RequestMessage)req, out -> in.transferTo((OutputStream)out));
            return internal;
        });
        ReadExchange.Request startReq = ReadExchange.Request.builder().provider(type).store((DataStore)store).target(id).configureAll(false).build();
        ReadExchange.Response startRes = XPipeApiConnection.execute(con -> (ReadExchange.Response)con.performSimpleExchange((RequestMessage)startReq));
        DialogReference configInstance = startRes.getConfig();
        XPipeApiConnection.finishDialog(configInstance);
        DataSourceReference ref = id != null ? DataSourceReference.id((DataStoreId)id) : DataSourceReference.latest();
        return DataSourceImpl.get(ref);
    }

    @Override
    public void forwardTo(DataSource target) {
        XPipeApiConnection.execute(con -> {
            ForwardExchange.Request req = ForwardExchange.Request.builder().source(DataSourceReference.id((DataStoreId)this.sourceId)).target(DataSourceReference.id((DataStoreId)target.getId())).build();
            ForwardExchange.Response res = (ForwardExchange.Response)con.performSimpleExchange((RequestMessage)req);
        });
    }

    @Override
    public void appendTo(DataSource target) {
        XPipeApiConnection.execute(con -> {
            ForwardExchange.Request req = ForwardExchange.Request.builder().source(DataSourceReference.id((DataStoreId)this.sourceId)).target(DataSourceReference.id((DataStoreId)target.getId())).append(true).build();
            ForwardExchange.Response res = (ForwardExchange.Response)con.performSimpleExchange((RequestMessage)req);
        });
    }

    @Override
    public io.xpipe.core.source.DataSource<?> getInternalSource() {
        return this.internalSource;
    }

    @Override
    public DataStoreId getId() {
        return this.sourceId;
    }

    @Override
    public DataSourceConfig getConfig() {
        return this.config;
    }
}

