/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.api.impl;

import io.xpipe.api.DataSourceConfig;
import io.xpipe.api.DataText;
import io.xpipe.api.impl.DataSourceImpl;
import io.xpipe.core.source.DataSource;
import io.xpipe.core.source.DataSourceType;
import io.xpipe.core.source.DataStoreId;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DataTextImpl
extends DataSourceImpl
implements DataText {
    DataTextImpl(DataStoreId sourceId, DataSourceConfig sourceConfig, DataSource<?> internalSource) {
        super(sourceId, sourceConfig, internalSource);
    }

    @Override
    public DataSourceType getType() {
        return DataSourceType.TEXT;
    }

    @Override
    public DataText asText() {
        return this;
    }

    @Override
    public List<String> readAllLines() {
        return this.readLines(Integer.MAX_VALUE);
    }

    @Override
    public List<String> readLines(int maxLines) {
        try (Stream<String> lines = this.lines();){
            List<String> list = lines.limit(maxLines).toList();
            return list;
        }
    }

    @Override
    public Stream<String> lines() {
        return Stream.of(new String[0]);
    }

    @Override
    public String readAll() {
        try (Stream<String> lines = this.lines();){
            String string = lines.collect(Collectors.joining("\n"));
            return string;
        }
    }

    @Override
    public String read(int maxCharacters) {
        StringBuilder builder = new StringBuilder();
        this.lines().takeWhile(s -> {
            if (builder.length() > maxCharacters) {
                return false;
            }
            builder.append((String)s);
            return true;
        });
        return builder.toString();
    }
}

