/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.api.impl;

import io.xpipe.api.DataSource;
import io.xpipe.api.DataTable;
import io.xpipe.api.DataTableAccumulator;
import io.xpipe.api.connector.XPipeApiConnection;
import io.xpipe.api.util.TypeDescriptor;
import io.xpipe.beacon.BeaconConnection;
import io.xpipe.beacon.BeaconException;
import io.xpipe.beacon.RequestMessage;
import io.xpipe.beacon.exchange.ReadExchange;
import io.xpipe.beacon.exchange.WriteStreamExchange;
import io.xpipe.beacon.exchange.cli.StoreAddExchange;
import io.xpipe.beacon.util.QuietDialogHandler;
import io.xpipe.core.data.node.DataStructureNode;
import io.xpipe.core.data.node.DataStructureNodeAcceptor;
import io.xpipe.core.data.node.TupleNode;
import io.xpipe.core.data.type.DataType;
import io.xpipe.core.data.type.TupleType;
import io.xpipe.core.data.typed.TypedDataStreamWriter;
import io.xpipe.core.dialog.DialogReference;
import io.xpipe.core.impl.InternalStreamStore;
import io.xpipe.core.source.DataSourceId;
import io.xpipe.core.source.DataSourceReference;
import io.xpipe.core.store.DataStore;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class DataTableAccumulatorImpl
implements DataTableAccumulator {
    private final XPipeApiConnection connection;
    private final TupleType type;
    private int rows;
    private final InternalStreamStore store;
    private TupleType writtenDescriptor;
    private final OutputStream bodyOutput;

    public DataTableAccumulatorImpl(TupleType type) {
        this.type = type;
        this.connection = XPipeApiConnection.open();
        this.store = new InternalStreamStore();
        StoreAddExchange.Request addReq = StoreAddExchange.Request.builder().storeInput((DataStore)this.store).name(this.store.getUuid().toString()).build();
        StoreAddExchange.Response addRes = (StoreAddExchange.Response)this.connection.performSimpleExchange((RequestMessage)addReq);
        QuietDialogHandler.handle((DialogReference)addRes.getConfig(), (BeaconConnection)this.connection);
        this.connection.sendRequest((RequestMessage)WriteStreamExchange.Request.builder().name(this.store.getUuid().toString()).build());
        this.bodyOutput = this.connection.sendBody();
    }

    @Override
    public synchronized DataTable finish(DataSourceId id) {
        try {
            this.bodyOutput.close();
        }
        catch (IOException e) {
            throw new BeaconException((Throwable)e);
        }
        WriteStreamExchange.Response res = (WriteStreamExchange.Response)this.connection.receiveResponse();
        this.connection.close();
        ReadExchange.Request req = ReadExchange.Request.builder().target(id).store((DataStore)this.store).provider("xpbt").configureAll(false).build();
        ReadExchange.Response response = XPipeApiConnection.execute(con -> (ReadExchange.Response)con.performSimpleExchange((RequestMessage)req));
        DialogReference configInstance = response.getConfig();
        XPipeApiConnection.finishDialog(configInstance);
        return DataSource.get(DataSourceReference.id((DataSourceId)id)).asTable();
    }

    private void writeDescriptor() {
        if (this.writtenDescriptor != null) {
            return;
        }
        this.writtenDescriptor = TupleType.tableType((List)this.type.getNames());
        this.connection.withOutputStream(out -> out.write(TypeDescriptor.create(this.type.getNames()).getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public synchronized void add(DataStructureNode row) {
        TupleNode toUse = this.type.matches(row) ? row.asTuple() : ((DataStructureNode)this.type.convert(row).orElseThrow()).asTuple();
        this.connection.withOutputStream(out -> {
            this.writeDescriptor();
            TypedDataStreamWriter.writeStructure((OutputStream)out, (DataStructureNode)toUse, (DataType)this.writtenDescriptor);
            ++this.rows;
        });
    }

    @Override
    public synchronized DataStructureNodeAcceptor<DataStructureNode> acceptor() {
        return node -> {
            this.add(node);
            return true;
        };
    }

    @Override
    public synchronized int getCurrentRows() {
        return this.rows;
    }
}

