/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.api.impl;

import io.xpipe.api.DataSourceConfig;
import io.xpipe.api.DataText;
import io.xpipe.api.connector.XPipeApiConnection;
import io.xpipe.api.impl.DataSourceImpl;
import io.xpipe.beacon.BeaconConnection;
import io.xpipe.beacon.BeaconException;
import io.xpipe.beacon.RequestMessage;
import io.xpipe.beacon.exchange.api.QueryTextDataExchange;
import io.xpipe.core.source.DataSource;
import io.xpipe.core.source.DataSourceId;
import io.xpipe.core.source.DataSourceReference;
import io.xpipe.core.source.DataSourceType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DataTextImpl
extends DataSourceImpl
implements DataText {
    DataTextImpl(DataSourceId sourceId, DataSourceConfig sourceConfig, DataSource<?> internalSource) {
        super(sourceId, sourceConfig, internalSource);
    }

    @Override
    public DataSourceType getType() {
        return DataSourceType.TEXT;
    }

    @Override
    public DataText asText() {
        return this;
    }

    @Override
    public List<String> readAllLines() {
        return this.readLines(Integer.MAX_VALUE);
    }

    @Override
    public List<String> readLines(int maxLines) {
        try (Stream<String> lines = this.lines();){
            List<String> list = lines.limit(maxLines).toList();
            return list;
        }
    }

    @Override
    public Stream<String> lines() {
        Iterator<String> iterator = new Iterator<String>(){
            private final BeaconConnection connection = XPipeApiConnection.open();
            private final BufferedReader reader;
            private String nextValue;
            {
                QueryTextDataExchange.Request req = QueryTextDataExchange.Request.builder().ref(DataSourceReference.id((DataSourceId)DataTextImpl.this.getId())).maxLines(-1).build();
                this.connection.sendRequest((RequestMessage)req);
                this.connection.receiveResponse();
                this.reader = new BufferedReader(new InputStreamReader(this.connection.receiveBody(), StandardCharsets.UTF_8));
            }

            private void close() {
                this.connection.close();
            }

            @Override
            public boolean hasNext() {
                this.connection.checkClosed();
                try {
                    this.nextValue = this.reader.readLine();
                }
                catch (IOException e) {
                    throw new BeaconException((Throwable)e);
                }
                return this.nextValue != null;
            }

            @Override
            public String next() {
                return this.nextValue;
            }
        };
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).onClose((iterator)::close);
    }

    @Override
    public String readAll() {
        try (Stream<String> lines = this.lines();){
            String string = lines.collect(Collectors.joining("\n"));
            return string;
        }
    }

    @Override
    public String read(int maxCharacters) {
        StringBuilder builder = new StringBuilder();
        this.lines().takeWhile(s -> {
            if (builder.length() > maxCharacters) {
                return false;
            }
            builder.append((String)s);
            return true;
        });
        return builder.toString();
    }
}

