/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.api.impl;

import io.xpipe.api.DataSourceConfig;
import io.xpipe.api.DataTable;
import io.xpipe.api.connector.XPipeApiConnection;
import io.xpipe.api.impl.DataSourceImpl;
import io.xpipe.beacon.BeaconConnection;
import io.xpipe.beacon.BeaconException;
import io.xpipe.beacon.RequestMessage;
import io.xpipe.beacon.exchange.api.QueryTableDataExchange;
import io.xpipe.core.data.node.ArrayNode;
import io.xpipe.core.data.node.TupleNode;
import io.xpipe.core.data.type.DataType;
import io.xpipe.core.data.typed.TypedAbstractReader;
import io.xpipe.core.data.typed.TypedDataStreamParser;
import io.xpipe.core.data.typed.TypedDataStructureNodeReader;
import io.xpipe.core.source.DataSource;
import io.xpipe.core.source.DataSourceId;
import io.xpipe.core.source.DataSourceReference;
import io.xpipe.core.source.DataSourceType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DataTableImpl
extends DataSourceImpl
implements DataTable {
    DataTableImpl(DataSourceId id, DataSourceConfig sourceConfig, DataSource<?> internalSource) {
        super(id, sourceConfig, internalSource);
    }

    @Override
    public DataTable asTable() {
        return this;
    }

    @Override
    public Stream<TupleNode> stream() {
        TableIterator iterator = new TableIterator();
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).onClose(iterator::finish);
    }

    @Override
    public DataSourceType getType() {
        return DataSourceType.TABLE;
    }

    @Override
    public ArrayNode readAll() {
        return this.read(Integer.MAX_VALUE);
    }

    @Override
    public ArrayNode read(int maxRows) {
        ArrayList nodes = new ArrayList();
        XPipeApiConnection.execute(con -> {
            QueryTableDataExchange.Request req = QueryTableDataExchange.Request.builder().ref(DataSourceReference.id((DataSourceId)this.getId())).maxRows(maxRows).build();
            con.performInputExchange((RequestMessage)req, (res, in) -> {
                TypedDataStreamParser r = new TypedDataStreamParser((DataType)res.getDataType());
                r.parseStructures(in, (TypedAbstractReader)TypedDataStructureNodeReader.of((DataType)res.getDataType()), nodes::add);
            });
        });
        return ArrayNode.of(nodes);
    }

    @Override
    public Iterator<TupleNode> iterator() {
        return new TableIterator();
    }

    private class TableIterator
    implements Iterator<TupleNode> {
        private final BeaconConnection connection = XPipeApiConnection.open();
        private final TypedDataStreamParser parser;
        private final TypedAbstractReader nodeReader;
        private TupleNode node;

        private TableIterator() {
            QueryTableDataExchange.Request req = QueryTableDataExchange.Request.builder().ref(DataSourceReference.id((DataSourceId)DataTableImpl.this.getId())).maxRows(Integer.MAX_VALUE).build();
            this.connection.sendRequest((RequestMessage)req);
            QueryTableDataExchange.Response response = (QueryTableDataExchange.Response)this.connection.receiveResponse();
            this.nodeReader = TypedDataStructureNodeReader.of((DataType)response.getDataType());
            this.parser = new TypedDataStreamParser((DataType)response.getDataType());
            this.connection.receiveBody();
        }

        private void finish() {
            this.connection.close();
        }

        @Override
        public boolean hasNext() {
            this.connection.checkClosed();
            try {
                this.node = (TupleNode)this.parser.parseStructure(this.connection.getInputStream(), this.nodeReader);
            }
            catch (IOException e) {
                throw new BeaconException((Throwable)e);
            }
            if (this.node == null) {
                // empty if block
            }
            return this.node != null;
        }

        @Override
        public TupleNode next() {
            this.connection.checkClosed();
            return this.node;
        }
    }
}

