/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.api.util;

import io.xpipe.beacon.BeaconConnection;
import io.xpipe.beacon.ClientException;
import io.xpipe.beacon.RequestMessage;
import io.xpipe.beacon.exchange.cli.DialogExchange;
import io.xpipe.core.dialog.BaseQueryElement;
import io.xpipe.core.dialog.ChoiceElement;
import io.xpipe.core.dialog.DialogElement;
import io.xpipe.core.dialog.DialogReference;
import java.util.Map;
import java.util.UUID;

public class QuietDialogHandler {
    private final UUID dialogKey;
    private final BeaconConnection connection;
    private final Map<String, String> overrides;
    private DialogElement element;

    public QuietDialogHandler(DialogReference ref, BeaconConnection connection, Map<String, String> overrides) {
        this.dialogKey = ref.getDialogId();
        this.element = ref.getStart();
        this.connection = connection;
        this.overrides = overrides;
    }

    public void handle() throws ClientException {
        DialogExchange.Response res;
        String response = null;
        DialogElement dialogElement = this.element;
        if (dialogElement instanceof ChoiceElement) {
            ChoiceElement c = (ChoiceElement)dialogElement;
            response = this.handleChoice(c);
        }
        if ((dialogElement = this.element) instanceof BaseQueryElement) {
            BaseQueryElement q = (BaseQueryElement)dialogElement;
            response = this.handleQuery(q);
        }
        if ((res = (DialogExchange.Response)this.connection.performSimpleExchange((RequestMessage)DialogExchange.Request.builder().dialogKey(this.dialogKey).value(response).build())).getElement() != null && this.element.equals((Object)res.getElement())) {
            throw new ClientException("Invalid value for key " + res.getElement().toDisplayString());
        }
        this.element = res.getElement();
        if (this.element != null) {
            this.handle();
        }
    }

    private String handleQuery(BaseQueryElement q) {
        if (q.isRequired() && !this.overrides.containsKey(q.getDescription())) {
            throw new IllegalStateException("Missing required config parameter: " + q.getDescription());
        }
        return this.overrides.get(q.getDescription());
    }

    private String handleChoice(ChoiceElement c) {
        if (c.isRequired() && !this.overrides.containsKey(c.getDescription())) {
            throw new IllegalStateException("Missing required config parameter: " + c.getDescription());
        }
        return this.overrides.get(c.getDescription());
    }
}

