/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.api;

import io.xpipe.api.DataRaw;
import io.xpipe.api.DataSourceConfig;
import io.xpipe.api.DataStructure;
import io.xpipe.api.DataTable;
import io.xpipe.api.DataText;
import io.xpipe.api.impl.DataSourceImpl;
import io.xpipe.core.source.DataSourceId;
import io.xpipe.core.source.DataSourceReference;
import io.xpipe.core.source.DataSourceType;
import io.xpipe.core.store.DataStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public interface DataSource {
    @Deprecated
    public static DataSource supplySource() {
        return null;
    }

    public static DataSource getById(String id) {
        return DataSource.get(DataSourceReference.id((String)id));
    }

    public static DataSource getLatest() {
        return DataSource.get(DataSourceReference.latest());
    }

    public static DataSource getByName(String name) {
        return DataSource.get(DataSourceReference.name((String)name));
    }

    public static DataSource get(DataSourceReference ref) {
        return DataSourceImpl.get(ref);
    }

    public static void unlock() {
        throw new UnsupportedOperationException();
    }

    public static DataSource createAnonymous(String type, Path path) {
        return DataSource.create(null, type, path);
    }

    public static DataSource create(DataSourceId id, String type, Path path) {
        DataSource dataSource;
        block8: {
            InputStream in = Files.newInputStream(path, new OpenOption[0]);
            try {
                dataSource = DataSource.create(id, type, in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            in.close();
        }
        return dataSource;
    }

    public static DataSource createAnonymous(String type, URL url) {
        return DataSource.create(null, type, url);
    }

    public static DataSource create(DataSourceId id, String type, URL url) {
        DataSource dataSource;
        block8: {
            InputStream in = url.openStream();
            try {
                dataSource = DataSource.create(id, type, in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            in.close();
        }
        return dataSource;
    }

    public static DataSource createAnonymous(String type, InputStream in) {
        return DataSource.create(null, type, in);
    }

    public static DataSource create(DataSourceId id, String type, InputStream in) {
        return DataSourceImpl.create(id, type, in);
    }

    public static DataSource create(DataSourceId id, io.xpipe.core.source.DataSource<?> source) {
        return DataSourceImpl.create(id, source);
    }

    public static DataSource create(DataSourceId id, String type, DataStore in) {
        return DataSourceImpl.create(id, type, in);
    }

    public void forwardTo(DataSource var1);

    public void appendTo(DataSource var1);

    public io.xpipe.core.source.DataSource<?> getInternalSource();

    public DataSourceId getId();

    public DataSourceType getType();

    public DataSourceConfig getConfig();

    default public DataTable asTable() {
        throw new UnsupportedOperationException("Data source is not a table");
    }

    default public DataStructure asStructure() {
        throw new UnsupportedOperationException("Data source is not a structure");
    }

    default public DataText asText() {
        throw new UnsupportedOperationException("Data source is not a text");
    }

    default public DataRaw asRaw() {
        throw new UnsupportedOperationException("Data source is not raw");
    }
}

