/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.wiring;

import io.webdevice.device.Device;
import io.webdevice.device.DeviceRegistry;
import io.webdevice.device.WebDevice;
import io.webdevice.test.UnitTest;
import io.webdevice.wiring.Settings;
import io.webdevice.wiring.WebDeviceRuntime;
import java.net.URL;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.openqa.selenium.WebDriver;

public class WebDeviceRuntimeTest
extends UnitTest {
    private Settings settings;
    private WebDeviceRuntime runtime;
    @Mock
    private DeviceRegistry mockRegistry;
    @Mock
    private Device<WebDriver> mockDevice;

    @Before
    public void setUp() {
        this.settings = new Settings();
        this.runtime = new WebDeviceRuntime(this.settings);
    }

    @Test
    public void shouldCreateWebDeviceFromSettings() throws Exception {
        this.settings.withBaseUrl(new URL("http://localhost")).withDefaultDevice("iphone").withEager(true).withStrict(true);
        WebDevice webDevice = this.runtime.webDevice(this.mockRegistry);
        Assertions.assertThat((URL)webDevice.getBaseUrl()).isEqualTo((Object)new URL("http://localhost"));
        Assertions.assertThat((String)webDevice.getDefaultDevice()).isEqualTo("iphone");
        Assertions.assertThat((boolean)webDevice.isEager()).isTrue();
        Assertions.assertThat((boolean)webDevice.isStrict()).isTrue();
        BDDMockito.given((Object)this.mockRegistry.provide("iphone")).willReturn(this.mockDevice);
        webDevice.initialize();
    }
}

