/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.wiring;

import io.webdevice.wiring.DeviceDefinition;
import io.webdevice.wiring.EnvironmentBasedTest;
import io.webdevice.wiring.Settings;
import java.net.URL;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.springframework.core.env.Environment;

public class SettingsTest
extends EnvironmentBasedTest {
    private Settings settings;

    @Before
    public void setUp() {
        this.settings = new Settings();
    }

    @Test
    public void shouldBindWebDeviceSpecificSettingsFromEnvironmentUsingDefaults() throws Exception {
        this.settings.withDefaultDevice("Foo").withStrict(true).withEager(false).withBaseUrl(null);
        Settings actual = Settings.settings((Environment)this.environmentWith("io/webdevice/wiring/default-device-only.yaml"));
        Assertions.assertThat((Object)actual).isEqualTo((Object)this.settings);
    }

    @Test
    public void shouldBindWebDeviceSpecificSettingsFromEnvironmentUsingNonDefaults() throws Exception {
        this.settings.withDefaultDevice("Foo").withStrict(false).withEager(true).withBaseUrl(new URL("http://webdevice.io"));
        Settings actual = Settings.settings((Environment)this.environmentWith("io/webdevice/wiring/non-defaults.yaml"));
        Assertions.assertThat((Object)actual).isEqualTo((Object)this.settings);
    }

    @Test
    public void shouldStreamDevices() {
        DeviceDefinition iPhone = new DeviceDefinition().withName("iPhone");
        DeviceDefinition iPad = new DeviceDefinition().withName("iPad");
        this.settings.withDevice(iPhone).withDevice(iPad);
        Assertions.assertThat((Stream)this.settings.devices()).contains((Object[])new DeviceDefinition[]{iPhone, iPad});
    }
}

