/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.wiring;

import io.webdevice.support.CustomFirefoxProvider;
import io.webdevice.util.Collections;
import io.webdevice.wiring.DeviceDefinition;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;

public class BasicDeviceDefinitionTest {
    private DeviceDefinition definition;

    @Before
    public void setUp() {
        this.definition = new DeviceDefinition();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldReturnUnmodifiableAliases() {
        this.definition.withAlias("Device");
        this.definition.getAliases().add("Local Device");
    }

    @Test
    public void shouldSetAliases() {
        this.definition.setAliases(Collections.setOf("Local Device", "Device"));
        Assertions.assertThat((Iterable)this.definition.getAliases()).containsExactly((Object[])new String[]{"Local Device", "Device"});
    }

    @Test
    public void shouldReturnStreamOfAliases() {
        this.definition.withAlias("Device").withAlias("Local Device");
        Assertions.assertThat((Stream)this.definition.aliases()).containsExactly((Object[])new String[]{"Device", "Local Device"});
    }

    @Test
    public void shouldSetPooled() {
        Assertions.assertThat((boolean)this.definition.isPooled()).isFalse();
        this.definition.withPooled(true);
        Assertions.assertThat((boolean)this.definition.isPooled()).isTrue();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldReturnUnmodifiableCapabilities() {
        this.definition.withCapability("name", (Object)"value");
        this.definition.getCapabilities().put("name-2", "value-2");
    }

    @Test
    public void shouldSetCapabilities() {
        HashMap<String, String> capabilities = new HashMap<String, String>();
        capabilities.put("name-1", "value-1");
        capabilities.put("name-2", "value-2");
        this.definition.setCapabilities(capabilities);
        Assertions.assertThat((Map)this.definition.getCapabilities()).isEqualTo(capabilities);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldReturnUnmodifiableExtraOptions() {
        this.definition.withExtraOption("name", (Object)"value");
        this.definition.getExtraOptions().put("name-2", "value-2");
    }

    @Test
    public void shouldSetExtraOptions() {
        HashMap<String, String> extraOptions = new HashMap<String, String>();
        extraOptions.put("name-1", "value-1");
        extraOptions.put("name-2", "value-2");
        this.definition.setExtraOptions(extraOptions);
        Assertions.assertThat((Map)this.definition.getExtraOptions()).isEqualTo(extraOptions);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldReturnUnmodifiableConfidentialKeys() {
        this.definition.withConfidential("accessKey");
        this.definition.getConfidential().add("password");
    }

    @Test
    public void shouldSetConfidentialKeys() {
        this.definition.setConfidential(Collections.setOf("accessKey", "password"));
        Assertions.assertThat((Iterable)this.definition.getConfidential()).containsExactly((Object[])new String[]{"accessKey", "password"});
    }

    @Test
    public void twoProvidedDevicesShouldBeEqual() {
        this.definition.withName("myDevice").withProvider(CustomFirefoxProvider.class);
        DeviceDefinition metadata2 = new DeviceDefinition().withName("myDevice").withProvider(CustomFirefoxProvider.class);
        Assertions.assertThat((Object)metadata2).isEqualTo((Object)this.definition);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRaiseExceptionWhenDesiredCapabilitiesFactoryMethodDoesNotExist() {
        this.definition.withName("myDevice").withDriver(FirefoxDriver.class).withDesired("doesNotExist").build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldRaiseExceptionWhenFailureOccursConstructingOptions() {
        this.definition.withName("myDevice").withDriver(FirefoxDriver.class).withOptions(BadOptions.class).build();
    }

    public static class BadOptions
    extends FirefoxOptions {
        private BadOptions() {
        }
    }
}

