/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.wiring;

import io.webdevice.support.CustomFirefoxProvider;
import io.webdevice.util.Collections;
import io.webdevice.wiring.DeviceDefinition;
import io.webdevice.wiring.DeviceDefinitionTest;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

public class ProvidedDeviceDefinitionTest
implements DeviceDefinitionTest {
    private DeviceDefinition definition;

    @Before
    public void setUp() {
        this.definition = new DeviceDefinition();
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithoutCapabilitiesAndWithoutConfidential() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withProvider(CustomFirefoxProvider.class).build().getBeanDefinition();
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(CustomFirefoxProvider.class).addConstructorArgValue((Object)"myDevice").setScope("singleton").setRole(2).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithoutCapabilitiesAndWithConfidential() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withProvider(CustomFirefoxProvider.class).withConfidential("accessKey").build().getBeanDefinition();
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(CustomFirefoxProvider.class).addConstructorArgValue((Object)"myDevice").setScope("singleton").setRole(2).addPropertyValue("confidential", Collections.setOf("accessKey")).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithCapabilitiesReference() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withProvider(CustomFirefoxProvider.class).withCapabilitiesRef("myDeviceCapabilities").build().getBeanDefinition();
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(CustomFirefoxProvider.class).addConstructorArgValue((Object)"myDevice").setScope("singleton").setRole(2).addPropertyReference("capabilities", "myDeviceCapabilities").getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithOptionsOnly() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withProvider(CustomFirefoxProvider.class).withOptions(FirefoxOptions.class).build().getBeanDefinition();
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(CustomFirefoxProvider.class).addConstructorArgValue((Object)"myDevice").setScope("singleton").setRole(2).addPropertyValue("capabilities", (Object)new FirefoxOptions()).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithOptionsMergingCapabilities() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withProvider(CustomFirefoxProvider.class).withOptions(FirefoxOptions.class).withCapability("key", (Object)"value").build().getBeanDefinition();
        FirefoxOptions expectedOptions = new FirefoxOptions();
        expectedOptions.setCapability("key", "value");
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(CustomFirefoxProvider.class).addConstructorArgValue((Object)"myDevice").setScope("singleton").setRole(2).addPropertyValue("capabilities", (Object)expectedOptions).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithOptionsMergingExtraCapabilities() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withProvider(CustomFirefoxProvider.class).withOptions(FirefoxOptions.class).withExtraCapability("sauce:options").withExtraOption("accessKey", (Object)"2secret4u").build().getBeanDefinition();
        FirefoxOptions expectedOptions = new FirefoxOptions();
        expectedOptions.setCapability("sauce:options", (Object)new DesiredCapabilities(Collections.mapOf("accessKey", "2secret4u")));
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(CustomFirefoxProvider.class).addConstructorArgValue((Object)"myDevice").setScope("singleton").setRole(2).addPropertyValue("capabilities", (Object)expectedOptions).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithOptionsMergingCapabilitiesAndExtraCapabilities() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withProvider(CustomFirefoxProvider.class).withOptions(FirefoxOptions.class).withCapability("key", (Object)"value").withExtraCapability("sauce:options").withExtraOption("accessKey", (Object)"2secret4u").build().getBeanDefinition();
        FirefoxOptions expectedOptions = new FirefoxOptions();
        expectedOptions.setCapability("key", "value");
        expectedOptions.setCapability("sauce:options", (Object)new DesiredCapabilities(Collections.mapOf("accessKey", "2secret4u")));
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(CustomFirefoxProvider.class).addConstructorArgValue((Object)"myDevice").setScope("singleton").setRole(2).addPropertyValue("capabilities", (Object)expectedOptions).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithDesiredOnly() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withProvider(CustomFirefoxProvider.class).withDesired("iphone").build().getBeanDefinition();
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(CustomFirefoxProvider.class).addConstructorArgValue((Object)"myDevice").setScope("singleton").setRole(2).addPropertyValue("capabilities", (Object)DesiredCapabilities.iphone()).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithDesiredMergingCapabilities() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withProvider(CustomFirefoxProvider.class).withDesired("iphone").withCapability("key", (Object)"value").build().getBeanDefinition();
        DesiredCapabilities expectedCapabilities = DesiredCapabilities.iphone();
        expectedCapabilities.setCapability("key", "value");
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(CustomFirefoxProvider.class).addConstructorArgValue((Object)"myDevice").setScope("singleton").setRole(2).addPropertyValue("capabilities", (Object)expectedCapabilities).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithDesiredMergingExtraCapabilities() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withProvider(CustomFirefoxProvider.class).withDesired("iphone").withExtraCapability("sauce:options").withExtraOption("accessKey", (Object)"2secret4u").build().getBeanDefinition();
        DesiredCapabilities expectedCapabilities = DesiredCapabilities.iphone();
        expectedCapabilities.setCapability("sauce:options", (Object)new DesiredCapabilities(Collections.mapOf("accessKey", "2secret4u")));
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(CustomFirefoxProvider.class).addConstructorArgValue((Object)"myDevice").setScope("singleton").setRole(2).addPropertyValue("capabilities", (Object)expectedCapabilities).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithDesiredMergingCapabilitiesAndExtraCapabilities() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withProvider(CustomFirefoxProvider.class).withDesired("iphone").withCapability("key", (Object)"value").withExtraCapability("sauce:options").withExtraOption("accessKey", (Object)"2secret4u").build().getBeanDefinition();
        DesiredCapabilities expectedCapabilities = DesiredCapabilities.iphone();
        expectedCapabilities.setCapability("key", "value");
        expectedCapabilities.setCapability("sauce:options", (Object)new DesiredCapabilities(Collections.mapOf("accessKey", "2secret4u")));
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(CustomFirefoxProvider.class).addConstructorArgValue((Object)"myDevice").setScope("singleton").setRole(2).addPropertyValue("capabilities", (Object)expectedCapabilities).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithMapOnly() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withProvider(CustomFirefoxProvider.class).withCapability("key", (Object)"value").build().getBeanDefinition();
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(CustomFirefoxProvider.class).addConstructorArgValue((Object)"myDevice").setScope("singleton").setRole(2).addPropertyValue("capabilities", (Object)new DesiredCapabilities(Collections.mapOf("key", "value"))).getBeanDefinition());
    }

    @Override
    @Test
    public void shouldBuildDefinitionWithMapMergingExtraCapabilities() {
        AbstractBeanDefinition actual = this.definition.withName("myDevice").withProvider(CustomFirefoxProvider.class).withCapability("key", (Object)"value").withExtraCapability("sauce:options").withExtraOption("accessKey", (Object)"2secret4u").build().getBeanDefinition();
        DesiredCapabilities expectedCapabilities = new DesiredCapabilities(Collections.mapOf("key", "value"));
        expectedCapabilities.setCapability("sauce:options", (Object)new DesiredCapabilities(Collections.mapOf("accessKey", "2secret4u")));
        Assertions.assertThat((Object)actual).isEqualTo((Object)BeanDefinitionBuilder.genericBeanDefinition(CustomFirefoxProvider.class).addConstructorArgValue((Object)"myDevice").setScope("singleton").setRole(2).addPropertyValue("capabilities", (Object)expectedCapabilities).getBeanDefinition());
    }
}

