/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.wiring;

import io.webdevice.device.DevicePool;
import io.webdevice.support.SimpleDeviceCheck;
import io.webdevice.wiring.DeviceDefinition;
import io.webdevice.wiring.DeviceRegistrar;
import io.webdevice.wiring.EnvironmentBasedTest;
import io.webdevice.wiring.Settings;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.type.AnnotationMetadata;

public class DeviceRegistrarTest
extends EnvironmentBasedTest {
    @Mock
    private AnnotationMetadata mockMetadata;
    @Mock
    private BeanDefinitionRegistry mockRegistry;
    @Captor
    private ArgumentCaptor<GenericBeanDefinition> definitionCaptor;

    @After
    public void tearDown() throws Exception {
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockMetadata});
    }

    @Test
    public void shouldSkipRegisteringDeviceIfAlreadyDefined() throws Exception {
        DeviceRegistrar registrar = new DeviceRegistrar((Environment)this.environmentWith("io/webdevice/wiring/direct-pooled-device.yaml"));
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("Direct")).willReturn((Object)true);
        registrar.registerBeanDefinitions(this.mockMetadata, this.mockRegistry);
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("Direct");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRegistry});
    }

    @Test
    public void shouldSkipRegisteringPoolForPooledDeviceIfAlreadyDefinedAndAliasPoolWithDeviceName() throws Exception {
        StandardEnvironment environment = this.environmentWith("io/webdevice/wiring/direct-pooled-device.yaml");
        DeviceRegistrar registrar = new DeviceRegistrar((Environment)environment);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("Direct")).willReturn((Object)false);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("Direct-provider")).willReturn((Object)false);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("Direct-pool")).willReturn((Object)true);
        registrar.registerBeanDefinitions(this.mockMetadata, this.mockRegistry);
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("Direct");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("Direct-provider");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"Direct-provider"), (BeanDefinition)this.definitionCaptor.capture());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("Direct-pool");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerAlias("Direct-pool", "Direct");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRegistry});
        GenericBeanDefinition provider = (GenericBeanDefinition)this.definitionCaptor.getValue();
        DeviceDefinition definition = Settings.settings((Environment)environment).device("Direct");
        Assertions.assertThat((Object)provider).isEqualTo((Object)definition.build().getBeanDefinition());
    }

    @Test
    public void shouldSkipRegisteringProviderForPooledDeviceIfAlreadyDefinedAndAliasPoolWithDeviceName() throws Exception {
        StandardEnvironment environment = this.environmentWith("io/webdevice/wiring/direct-pooled-device.yaml");
        DeviceRegistrar registrar = new DeviceRegistrar((Environment)environment);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("Direct")).willReturn((Object)false);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("Direct-provider")).willReturn((Object)true);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("Direct-pool")).willReturn((Object)false);
        registrar.registerBeanDefinitions(this.mockMetadata, this.mockRegistry);
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("Direct");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("Direct-provider");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("Direct-pool");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"Direct-pool"), (BeanDefinition)this.definitionCaptor.capture());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerAlias("Direct-pool", "Direct");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRegistry});
        GenericBeanDefinition pool = (GenericBeanDefinition)this.definitionCaptor.getValue();
        Assertions.assertThat((Class)pool.getBeanClass()).isSameAs(DevicePool.class);
        Assertions.assertThat((int)pool.getAutowireMode()).isSameAs((Object)3);
        Assertions.assertThat((String)pool.getDestroyMethodName()).isEqualTo("dispose");
        ConstructorArgumentValues values = pool.getConstructorArgumentValues();
        Assertions.assertThat((int)values.getArgumentCount()).isSameAs((Object)3);
        Assertions.assertThat((Object)values.getIndexedArgumentValue(0, String.class).getValue()).isEqualTo((Object)"Direct");
        Assertions.assertThat((Object)values.getIndexedArgumentValue(1, String.class).getValue()).isEqualTo((Object)new RuntimeBeanReference("Direct-provider"));
        Assertions.assertThat((Object)values.getIndexedArgumentValue(2, String.class).getValue()).isInstanceOf(SimpleDeviceCheck.class);
    }

    @Test
    public void shouldRegisterPooledDeviceAndAliasPoolWithDeviceName() throws Exception {
        StandardEnvironment environment = this.environmentWith("io/webdevice/wiring/direct-pooled-device.yaml");
        DeviceRegistrar registrar = new DeviceRegistrar((Environment)environment);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("Direct")).willReturn((Object)false);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("Direct-provider")).willReturn((Object)false);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("Direct-pool")).willReturn((Object)false);
        registrar.registerBeanDefinitions(this.mockMetadata, this.mockRegistry);
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("Direct");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("Direct-provider");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"Direct-provider"), (BeanDefinition)this.definitionCaptor.capture());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("Direct-pool");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"Direct-pool"), (BeanDefinition)this.definitionCaptor.capture());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerAlias("Direct-pool", "Direct");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRegistry});
        GenericBeanDefinition provider = (GenericBeanDefinition)this.definitionCaptor.getAllValues().get(0);
        DeviceDefinition definition = Settings.settings((Environment)environment).device("Direct");
        Assertions.assertThat((Object)provider).isEqualTo((Object)definition.build().getBeanDefinition());
        GenericBeanDefinition pool = (GenericBeanDefinition)this.definitionCaptor.getAllValues().get(1);
        Assertions.assertThat((Class)pool.getBeanClass()).isSameAs(DevicePool.class);
        Assertions.assertThat((int)pool.getAutowireMode()).isSameAs((Object)3);
        Assertions.assertThat((String)pool.getDestroyMethodName()).isEqualTo("dispose");
        ConstructorArgumentValues values = pool.getConstructorArgumentValues();
        Assertions.assertThat((int)values.getArgumentCount()).isSameAs((Object)3);
        Assertions.assertThat((Object)values.getIndexedArgumentValue(0, String.class).getValue()).isEqualTo((Object)"Direct");
        Assertions.assertThat((Object)values.getIndexedArgumentValue(1, String.class).getValue()).isEqualTo((Object)new RuntimeBeanReference("Direct-provider"));
        Assertions.assertThat((Object)values.getIndexedArgumentValue(2, String.class).getValue()).isInstanceOf(SimpleDeviceCheck.class);
    }

    @Test
    public void shouldRegisterUnpooledDeviceAndAliasProviderWithDeviceName() throws Exception {
        StandardEnvironment environment = this.environmentWith("io/webdevice/wiring/direct-unpooled-device.yaml");
        DeviceRegistrar registrar = new DeviceRegistrar((Environment)environment);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("Direct")).willReturn((Object)false);
        BDDMockito.given((Object)this.mockRegistry.isBeanNameInUse("Direct-provider")).willReturn((Object)false);
        registrar.registerBeanDefinitions(this.mockMetadata, this.mockRegistry);
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("Direct");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).isBeanNameInUse("Direct-provider");
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerBeanDefinition((String)ArgumentMatchers.eq((Object)"Direct-provider"), (BeanDefinition)this.definitionCaptor.capture());
        ((BeanDefinitionRegistry)Mockito.verify((Object)this.mockRegistry)).registerAlias("Direct-provider", "Direct");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockRegistry});
        GenericBeanDefinition provider = (GenericBeanDefinition)this.definitionCaptor.getValue();
        DeviceDefinition definition = Settings.settings((Environment)environment).device("Direct");
        Assertions.assertThat((Object)provider).isEqualTo((Object)definition.build().getBeanDefinition());
    }
}

