/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.wiring;

import io.webdevice.wiring.DeviceSettings;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;

@ConfigurationProperties(value="webdevice")
public class Settings
implements Serializable {
    public static final String PREFIX = "webdevice";
    private final Map<String, DeviceSettings> devices = new LinkedHashMap<String, DeviceSettings>();
    private URL baseUrl;
    private String defaultDevice;
    private boolean eager = false;
    private boolean strict = true;

    public static Settings settings(Environment environment) {
        return (Settings)Binder.get((Environment)environment).bind(PREFIX, Settings.class).get();
    }

    public Map<String, DeviceSettings> getDevices() {
        return Collections.unmodifiableMap(this.devices);
    }

    public void setDevices(Map<String, DeviceSettings> devices) {
        this.devices.clear();
        this.devices.putAll(devices);
        this.devices.forEach((name, device) -> device.setName((String)name));
    }

    public Settings withDevice(DeviceSettings device) {
        this.devices.put(device.getName(), device);
        return this;
    }

    public Stream<DeviceSettings> devices() {
        return this.devices.values().stream();
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    public Settings withBaseUrl(URL baseUrl) {
        this.setBaseUrl(baseUrl);
        return this;
    }

    public String getDefaultDevice() {
        return this.defaultDevice;
    }

    public void setDefaultDevice(String defaultDevice) {
        this.defaultDevice = defaultDevice;
    }

    public Settings withDefaultDevice(String defaultDevice) {
        this.setDefaultDevice(defaultDevice);
        return this;
    }

    public boolean isEager() {
        return this.eager;
    }

    public void setEager(boolean eager) {
        this.eager = eager;
    }

    public Settings withEager(boolean eager) {
        this.setEager(eager);
        return this;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public Settings withStrict(boolean strict) {
        this.setStrict(strict);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Settings settings = (Settings)o;
        return this.eager == settings.eager && this.strict == settings.strict && Objects.equals(this.devices, settings.devices) && Objects.equals(this.baseUrl, settings.baseUrl) && Objects.equals(this.defaultDevice, settings.defaultDevice);
    }

    public int hashCode() {
        return Objects.hash(this.devices, this.baseUrl, this.defaultDevice, this.eager, this.strict);
    }
}

