/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.wiring;

import io.webdevice.device.DeviceProvider;
import io.webdevice.device.DirectDeviceProvider;
import io.webdevice.device.RemoteDeviceProvider;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;

public class DeviceSettings
implements Serializable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<String> aliases = new LinkedHashSet<String>();
    private final Map<String, Object> capabilities = new LinkedHashMap<String, Object>();
    private final Map<String, Object> extraOptions = new LinkedHashMap<String, Object>();
    private final Set<String> confidential = new LinkedHashSet<String>();
    private String name;
    private boolean pooled = true;
    private Class<? extends DeviceProvider> provider;
    private Class<? extends WebDriver> driver;
    private URL remoteAddress;
    private String capabilitiesRef;
    private Class<? extends MutableCapabilities> options;
    private String desired;
    private String extraCapability;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DeviceSettings withName(String name) {
        this.setName(name);
        return this;
    }

    public Set<String> getAliases() {
        return Collections.unmodifiableSet(this.aliases);
    }

    public void setAliases(Set<String> aliases) {
        this.aliases.clear();
        this.aliases.addAll(aliases);
    }

    public DeviceSettings withAlias(String alias) {
        this.aliases.add(alias);
        return this;
    }

    public Stream<String> aliases() {
        return this.aliases.stream();
    }

    public boolean isPooled() {
        return this.pooled;
    }

    public void setPooled(boolean pooled) {
        this.pooled = pooled;
    }

    public DeviceSettings withPooled(boolean pooled) {
        this.setPooled(pooled);
        return this;
    }

    public Class<? extends DeviceProvider> getProvider() {
        return this.provider;
    }

    public void setProvider(Class<? extends DeviceProvider> provider) {
        this.provider = provider;
    }

    public DeviceSettings withProvider(Class<? extends DeviceProvider> provider) {
        this.setProvider(provider);
        return this;
    }

    public boolean isProvided() {
        return this.provider != null;
    }

    public Class<? extends WebDriver> getDriver() {
        return this.driver;
    }

    public void setDriver(Class<? extends WebDriver> driver) {
        this.driver = driver;
    }

    public DeviceSettings withDriver(Class<? extends WebDriver> driver) {
        this.setDriver(driver);
        return this;
    }

    public URL getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(URL remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public DeviceSettings withRemoteAddress(URL remoteAddress) {
        this.setRemoteAddress(remoteAddress);
        return this;
    }

    public boolean isRemote() {
        return this.remoteAddress != null;
    }

    public String getCapabilitiesRef() {
        return this.capabilitiesRef;
    }

    public void setCapabilitiesRef(String capabilitiesRef) {
        this.capabilitiesRef = capabilitiesRef;
    }

    public DeviceSettings withCapabilitiesRef(String capabilitiesRef) {
        this.setCapabilitiesRef(capabilitiesRef);
        return this;
    }

    public Class<? extends MutableCapabilities> getOptions() {
        return this.options;
    }

    public void setOptions(Class<? extends MutableCapabilities> options) {
        this.options = options;
    }

    public DeviceSettings withOptions(Class<? extends MutableCapabilities> options) {
        this.setOptions(options);
        return this;
    }

    public String getDesired() {
        return this.desired;
    }

    public void setDesired(String desired) {
        this.desired = desired;
    }

    public DeviceSettings withDesired(String desired) {
        this.setDesired(desired);
        return this;
    }

    public Map<String, Object> getCapabilities() {
        return Collections.unmodifiableMap(this.capabilities);
    }

    public void setCapabilities(Map<String, Object> capabilities) {
        this.capabilities.clear();
        this.capabilities.putAll(capabilities);
    }

    public DeviceSettings withCapability(String capability, Object value) {
        this.capabilities.put(capability, value);
        return this;
    }

    public String getExtraCapability() {
        return this.extraCapability;
    }

    public void setExtraCapability(String extraCapability) {
        this.extraCapability = extraCapability;
    }

    public DeviceSettings withExtraCapability(String extraCapability) {
        this.extraCapability = extraCapability;
        return this;
    }

    public Map<String, Object> getExtraOptions() {
        return Collections.unmodifiableMap(this.extraOptions);
    }

    public void setExtraOptions(Map<String, Object> extraOptions) {
        this.extraOptions.clear();
        this.extraOptions.putAll(extraOptions);
    }

    public DeviceSettings withExtraOption(String option, Object value) {
        this.extraOptions.put(option, value);
        return this;
    }

    public Set<String> getConfidential() {
        return Collections.unmodifiableSet(this.confidential);
    }

    public void setConfidential(Set<String> confidential) {
        this.confidential.clear();
        this.confidential.addAll(confidential);
    }

    public DeviceSettings withConfidential(String mask) {
        this.confidential.add(mask);
        return this;
    }

    public BeanDefinitionBuilder definitionOf() {
        BeanDefinitionBuilder definition = this.isProvided() ? BeanDefinitionBuilder.genericBeanDefinition(this.provider).addConstructorArgValue((Object)this.name) : (this.isRemote() ? BeanDefinitionBuilder.genericBeanDefinition(RemoteDeviceProvider.class).addConstructorArgValue((Object)this.name).addConstructorArgValue((Object)this.remoteAddress).setAutowireMode(3) : BeanDefinitionBuilder.genericBeanDefinition(DirectDeviceProvider.class).addConstructorArgValue((Object)this.name).addConstructorArgValue(this.driver).setAutowireMode(3));
        return this.addConfidential(this.addCapabilities(definition));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceSettings device = (DeviceSettings)o;
        return this.pooled == device.pooled && Objects.equals(this.name, device.name) && Objects.equals(this.aliases, device.aliases) && Objects.equals(this.provider, device.provider) && Objects.equals(this.driver, device.driver) && Objects.equals(this.remoteAddress, device.remoteAddress) && Objects.equals(this.capabilitiesRef, device.capabilitiesRef) && Objects.equals(this.options, device.options) && Objects.equals(this.desired, device.desired) && Objects.equals(this.capabilities, device.capabilities) && Objects.equals(this.extraCapability, device.extraCapability) && Objects.equals(this.extraOptions, device.extraOptions) && Objects.equals(this.confidential, device.confidential);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.aliases, this.pooled, this.provider, this.driver, this.remoteAddress, this.capabilitiesRef, this.options, this.desired, this.capabilities, this.extraCapability, this.extraOptions, this.confidential);
    }

    private MutableCapabilities withCapabilities(MutableCapabilities capabilities) {
        if (!this.capabilities.isEmpty()) {
            this.log.info("Merging {} custom capabilities", (Object)this.name);
            capabilities.merge((Capabilities)new DesiredCapabilities(this.capabilities));
        }
        return capabilities;
    }

    private MutableCapabilities withExtraCapability(MutableCapabilities capabilities) {
        if (!this.extraOptions.isEmpty()) {
            this.log.info("{} capabilities will include {}", (Object)this.name, (Object)this.extraCapability);
            capabilities.setCapability(this.extraCapability, (Object)new DesiredCapabilities(this.extraOptions));
        }
        return capabilities;
    }

    private MutableCapabilities options() {
        try {
            return this.options.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Failure invoking new %s()", this.options.getName()), e);
        }
    }

    private MutableCapabilities fromOptions() {
        this.log.info("{} capabilities will originate from {}", (Object)this.name, (Object)this.options.getName());
        return this.withExtraCapability(this.withCapabilities(this.options()));
    }

    private DesiredCapabilities desired() {
        try {
            return (DesiredCapabilities)DesiredCapabilities.class.getDeclaredMethod(this.desired, new Class[0]).invoke(DesiredCapabilities.class, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Failure invoking DesiredCapabilities.%s()", this.desired), e);
        }
    }

    private MutableCapabilities fromDesiredCapabilities() {
        this.log.info("{} capabilities will originate from DesiredCapabilities.{}()", (Object)this.name, (Object)this.desired);
        return this.withExtraCapability(this.withCapabilities((MutableCapabilities)this.desired()));
    }

    private MutableCapabilities fromCapabilities() {
        this.log.info("{} capabilities will originate from custom capabilities", (Object)this.name);
        return this.withExtraCapability((MutableCapabilities)new DesiredCapabilities(this.capabilities));
    }

    private MutableCapabilities capabilitiesOf() {
        if (this.options != null) {
            return this.fromOptions();
        }
        if (this.desired != null) {
            return this.fromDesiredCapabilities();
        }
        if (!this.capabilities.isEmpty()) {
            return this.fromCapabilities();
        }
        this.log.info("Will not add custom capabilities to {}", (Object)this.name);
        return null;
    }

    private BeanDefinitionBuilder addCapabilities(BeanDefinitionBuilder definition) {
        MutableCapabilities capabilities = this.capabilitiesOf();
        if (capabilities != null) {
            this.log.info("{} adding computed capabilities to BeanDefinition", (Object)this.name);
            definition.addPropertyValue("capabilities", (Object)capabilities);
        } else if (this.capabilitiesRef != null) {
            this.log.info("{} adding capabilities reference to BeanDefinition", (Object)this.name);
            definition.addPropertyReference("capabilities", this.capabilitiesRef);
        }
        return definition;
    }

    private BeanDefinitionBuilder addConfidential(BeanDefinitionBuilder definition) {
        definition.addPropertyValue("confidential", this.confidential);
        return definition;
    }
}

