/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.wiring;

import io.webdevice.device.Device;
import io.webdevice.device.DevicePool;
import io.webdevice.wiring.DeviceSettings;
import io.webdevice.wiring.Settings;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

@Order
public class DeviceRegistrar
implements ImportBeanDefinitionRegistrar {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Environment environment;

    @Autowired
    public DeviceRegistrar(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        Settings settings = Settings.settings(this.environment);
        this.registerDevices(settings, registry);
    }

    private String maybeRegisterProvider(DeviceSettings device, BeanDefinitionRegistry registry) {
        String provider = String.format("%s-provider", device.getName());
        if (!registry.isBeanNameInUse(provider)) {
            this.log.info("Registering WebDeviceProvider definition named {}", (Object)provider);
            registry.registerBeanDefinition(provider, (BeanDefinition)device.definitionOf().getBeanDefinition());
        }
        return provider;
    }

    private String maybeRegisterPool(DeviceSettings device, String provider, BeanDefinitionRegistry registry) {
        String pool = String.format("%s-pool", device.getName());
        if (!registry.isBeanNameInUse(pool)) {
            this.log.info("Registering WebDevicePool definition named {}", (Object)pool);
            registry.registerBeanDefinition(pool, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(DevicePool.class).addConstructorArgValue((Object)device.getName()).addConstructorArgReference(provider).addConstructorArgValue(this::test).setAutowireMode(3).getBeanDefinition());
        }
        return pool;
    }

    private void registerAliases(String canonical, DeviceSettings device, BeanDefinitionRegistry registry) {
        this.log.info("Registering alias '{}' for '{}'", (Object)device.getName(), (Object)canonical);
        registry.registerAlias(canonical, device.getName());
        device.aliases().forEach(alias -> {
            this.log.info("Registering alias '{}' for '{}'", alias, (Object)canonical);
            registry.registerAlias(canonical, alias);
        });
    }

    private void registerDevices(Settings settings, BeanDefinitionRegistry registry) {
        this.log.info("Registering devices ...");
        settings.devices().filter(device -> !registry.isBeanNameInUse(device.getName())).forEach(device -> {
            String provider = this.maybeRegisterProvider((DeviceSettings)device, registry);
            if (device.isPooled()) {
                provider = this.maybeRegisterPool((DeviceSettings)device, provider, registry);
            }
            this.registerAliases(provider, (DeviceSettings)device, registry);
        });
        this.log.info("Devices registered.");
    }

    protected Boolean test(Device<? extends WebDriver> device) {
        return true;
    }
}

