/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.wiring;

import io.webdevice.device.DevicePool;
import io.webdevice.device.WebDevice;
import io.webdevice.support.SimpleDeviceCheck;
import io.webdevice.support.SpringDeviceRegistry;
import io.webdevice.wiring.DeviceDefinition;
import io.webdevice.wiring.Settings;
import io.webdevice.wiring.WebDeviceScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

@Order(value=0x7FFFFFFF)
public class WebDeviceRegistrar
implements ImportBeanDefinitionRegistrar {
    public static final String SETTINGS_PREFIX = "webdevice";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Environment environment;

    @Autowired
    public WebDeviceRegistrar(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        Settings settings = WebDeviceRegistrar.settings(this.environment);
        WebDeviceScope.registerScope((ConfigurableListableBeanFactory)registry);
        this.registerSettings(settings, registry);
        this.registerDevices(settings, registry);
        this.registerDeviceRegistry(settings, registry);
        this.registerWebDevice(settings, registry);
    }

    private String maybeRegisterProvider(DeviceDefinition device, BeanDefinitionRegistry registry) {
        String provider = WebDeviceRegistrar.namespace("%s-Provider", device.getName());
        if (!registry.isBeanNameInUse(provider)) {
            this.log.info("Registering WebDeviceProvider definition named {}", (Object)provider);
            registry.registerBeanDefinition(provider, (BeanDefinition)device.build().getBeanDefinition());
        }
        return provider;
    }

    private String maybeRegisterPool(String provider, DeviceDefinition device, BeanDefinitionRegistry registry) {
        String pool = WebDeviceRegistrar.namespace("%s-Pool", device.getName());
        if (!registry.isBeanNameInUse(pool)) {
            this.log.info("Registering WebDevicePool definition named {}", (Object)pool);
            registry.registerBeanDefinition(pool, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(DevicePool.class).addConstructorArgValue((Object)device.getName()).addConstructorArgReference(provider).addConstructorArgValue((Object)new SimpleDeviceCheck()).setAutowireMode(3).setDestroyMethodName("dispose").getBeanDefinition());
        }
        return pool;
    }

    private void registerAliases(String canonical, DeviceDefinition device, BeanDefinitionRegistry registry) {
        this.log.info("Registering alias '{}' for '{}'", (Object)device.getName(), (Object)canonical);
        registry.registerAlias(canonical, device.getName());
        device.aliases().forEach(alias -> {
            this.log.info("Registering alias '{}' for '{}'", alias, (Object)canonical);
            registry.registerAlias(canonical, alias);
        });
    }

    private void registerSettings(Settings settings, BeanDefinitionRegistry registry) {
        this.log.info("Registering Settings ...");
        registry.registerBeanDefinition(WebDeviceRegistrar.namespace("Settings", new Object[0]), (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(Settings.class, () -> settings).getBeanDefinition());
        this.log.info("Settings registered.");
    }

    private void registerDevices(Settings settings, BeanDefinitionRegistry registry) {
        this.log.info("Registering Devices ...");
        settings.devices().filter(device -> {
            boolean defined = registry.isBeanNameInUse(WebDeviceRegistrar.namespace(device.getName(), new Object[0]));
            if (defined) {
                this.log.warn("Device {} is already defined, skipping registration", (Object)device.getName());
            }
            return !defined;
        }).forEach(device -> {
            String provider = this.maybeRegisterProvider((DeviceDefinition)device, registry);
            if (device.isPooled()) {
                provider = this.maybeRegisterPool(provider, (DeviceDefinition)device, registry);
            }
            this.registerAliases(provider, (DeviceDefinition)device, registry);
        });
        this.log.info("Devices registered.");
    }

    private void registerDeviceRegistry(Settings settings, BeanDefinitionRegistry registry) {
        String scope = settings.getScope();
        this.log.info("Registering DeviceRegistry in {} scope ...", (Object)scope);
        registry.registerBeanDefinition(WebDeviceRegistrar.namespace("DeviceRegistry", new Object[0]), (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(SpringDeviceRegistry.class).setScope(scope).setAutowireMode(3).getBeanDefinition());
        this.log.info("DeviceRegistry registered.");
    }

    private void registerWebDevice(Settings settings, BeanDefinitionRegistry registry) {
        String scope = settings.getScope();
        this.log.info("Registering WebDevice in {} scope ...", (Object)scope);
        registry.registerBeanDefinition(WebDeviceRegistrar.namespace("WebDevice", new Object[0]), (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(WebDevice.class).setScope(scope).addConstructorArgReference(WebDeviceRegistrar.namespace("DeviceRegistry", new Object[0])).setAutowireMode(3).addPropertyValue("baseUrl", (Object)settings.getBaseUrl()).addPropertyValue("defaultDevice", (Object)settings.getDefaultDevice()).addPropertyValue("eager", (Object)settings.isEager()).addPropertyValue("strict", (Object)settings.isStrict()).setInitMethodName("initialize").setDestroyMethodName("release").getBeanDefinition());
        this.log.info("WebDevice registered.");
    }

    public static String namespace(String name, Object ... args) {
        return String.format("%s.%s", SETTINGS_PREFIX, String.format(name, args));
    }

    public static Settings settings(Environment environment) {
        return (Settings)Binder.get((Environment)environment).bind(SETTINGS_PREFIX, Settings.class).orElse((Object)new Settings());
    }
}

