/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.wiring;

import io.webdevice.device.DeviceProvider;
import io.webdevice.wiring.WebDeviceRegistrar;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=0x7FFFFFFF)
@Component(value="webdevice.DynamicDependsOn")
public class DynamicDependsOn
implements BeanFactoryPostProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) throws BeansException {
        String registryName = WebDeviceRegistrar.namespace("DeviceRegistry", new Object[0]);
        BeanDefinition registry = factory.getBeanDefinition(registryName);
        String[] providers = factory.getBeanNamesForType(DeviceProvider.class);
        this.log.info("Establishing {} dependency on {}", (Object)registryName, Arrays.asList(providers));
        registry.setDependsOn(providers);
    }
}

