/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.wiring;

import io.cucumber.spring.CucumberTestContext;
import io.webdevice.wiring.WebDeviceRuntime;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.test.context.FilteredClassLoader;
import org.springframework.boot.test.context.runner.ApplicationContextRunner;

public class ScopedWiringTest {
    private ApplicationContextRunner runner;

    @Before
    public void setUp() {
        this.runner = new ApplicationContextRunner();
    }

    @Test
    public void shouldCreateInCucumberGlueScopeWhenCucumberTestContextOnClasspath() {
        ((ApplicationContextRunner)this.runner.withUserConfiguration(new Class[]{WebDeviceRuntime.class})).run(context -> {
            ConfigurableListableBeanFactory factory = context.getBeanFactory();
            Assertions.assertThat((String)factory.getBeanDefinition("webdevice.WebDevice").getScope()).isEqualTo("cucumber-glue");
            Assertions.assertThat((String)factory.getBeanDefinition("webdevice.DeviceRegistry").getScope()).isEqualTo("cucumber-glue");
        });
    }

    @Test
    public void shouldCreateInWebDeviceScopeWhenCucumberTestContextNotOnClasspath() {
        ((ApplicationContextRunner)((ApplicationContextRunner)this.runner.withUserConfiguration(new Class[]{WebDeviceRuntime.class})).withClassLoader((ClassLoader)new FilteredClassLoader(new Class[]{CucumberTestContext.class}))).run(context -> {
            ConfigurableListableBeanFactory factory = context.getBeanFactory();
            Assertions.assertThat((String)factory.getBeanDefinition("webdevice.WebDevice").getScope()).isEqualTo("web-device");
            Assertions.assertThat((String)factory.getBeanDefinition("webdevice.DeviceRegistry").getScope()).isEqualTo("web-device");
        });
    }

    @Test
    public void shouldCreateInConfiguredScopeWhenCucumberTestContextOnClasspath() {
        ((ApplicationContextRunner)((ApplicationContextRunner)this.runner.withUserConfiguration(new Class[]{WebDeviceRuntime.class})).withPropertyValues(new String[]{"webdevice.scope=application"})).run(context -> {
            ConfigurableListableBeanFactory factory = context.getBeanFactory();
            Assertions.assertThat((String)factory.getBeanDefinition("webdevice.WebDevice").getScope()).isEqualTo("application");
            Assertions.assertThat((String)factory.getBeanDefinition("webdevice.DeviceRegistry").getScope()).isEqualTo("application");
        });
    }
}

