/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.wiring;

import io.webdevice.device.DeviceRegistry;
import io.webdevice.device.WebDevice;
import io.webdevice.wiring.DeviceRegistrar;
import io.webdevice.wiring.Settings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;

@Configuration
@Import(value={DeviceRegistrar.class})
@ComponentScan(value={"io.webdevice.support", "io.webdevice.wiring"})
@EnableConfigurationProperties(value={Settings.class})
public class WebDeviceRuntime {
    private final Settings settings;

    @Autowired
    public WebDeviceRuntime(Settings settings) {
        this.settings = settings;
    }

    @Primary
    @Scope(value="cucumber-glue")
    @Bean(initMethod="initialize", destroyMethod="release")
    public WebDevice webDevice(DeviceRegistry registry) {
        return new WebDevice(registry).withBaseUrl(this.settings.getBaseUrl()).withDefaultDevice(this.settings.getDefaultDevice()).withEager(this.settings.isEager()).withStrict(this.settings.isStrict());
    }
}

