/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.support;

import io.webdevice.support.ProtectedCapabilities;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Set;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;

public class ProtectedWebDriver
extends RemoteWebDriver {
    private final Set<String> confidential;

    public ProtectedWebDriver(URL remoteAddress, Capabilities capabilities, Set<String> confidential) {
        super(remoteAddress, capabilities);
        this.confidential = confidential;
    }

    public ProtectedWebDriver(CommandExecutor executor, Capabilities capabilities, Set<String> confidential) {
        super(executor, capabilities);
        this.confidential = confidential;
    }

    protected void startSession(Capabilities capabilities) {
        super.startSession(capabilities);
        try {
            Field field = RemoteWebDriver.class.getDeclaredField("capabilities");
            field.setAccessible(true);
            field.set((Object)this, (Object)new ProtectedCapabilities(this.getCapabilities(), this.confidential));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

