/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.device;

import io.github.bonigarcia.wdm.WebDriverManager;
import io.webdevice.device.BaseDeviceProvider;
import io.webdevice.device.Device;
import io.webdevice.device.Devices;
import java.util.function.Function;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public class DirectDeviceProvider<Driver extends WebDriver>
extends BaseDeviceProvider<Driver> {
    private final Class<Driver> type;
    private final Function<Class<Driver>, WebDriverManager> factory;

    DirectDeviceProvider(String name, Class<Driver> type, Function<Class<Driver>, WebDriverManager> factory) {
        super(name);
        this.type = type;
        this.factory = factory;
    }

    public DirectDeviceProvider(String name, Class<Driver> type) {
        this(name, type, WebDriverManager::getInstance);
    }

    @Override
    public void initialize() {
        WebDriverManager manager = this.factory.apply(this.type);
        this.log.info("Setting up {}", this.type);
        manager.setup();
    }

    @Override
    public Device<Driver> get() {
        this.log.info("Providing new device named {}", (Object)this.name);
        return Devices.directDevice(this.name, this.newDriver());
    }

    private Driver newDriver() {
        try {
            if (this.capabilities == null) {
                this.log.info("Instantiating {} using no-args constructor", this.type);
                return (Driver)((WebDriver)this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            this.log.info("Instantiating {} with capabilities {}", this.type, (Object)this.maskedCapabilities());
            return (Driver)((WebDriver)this.type.getDeclaredConstructor(Capabilities.class).newInstance(this.capabilities));
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
    }
}

