/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.device;

import io.webdevice.device.Device;
import io.webdevice.device.DeviceProvider;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;

public class Devices {
    private Devices() {
    }

    public static SessionId randomSessionId() {
        return new SessionId(UUID.randomUUID());
    }

    public static <Driver extends WebDriver> Function<Driver, SessionId> fixedSession(SessionId sessionId) {
        return driver -> sessionId;
    }

    public static <Driver extends WebDriver> Function<Driver, SessionId> fixedSession() {
        return Devices.fixedSession(Devices.randomSessionId());
    }

    public static <Driver extends RemoteWebDriver> Function<Driver, SessionId> remoteSession() {
        return RemoteWebDriver::getSessionId;
    }

    public static <Driver extends RemoteWebDriver> Device<Driver> remoteDevice(String name, Driver driver) {
        return new Device<Driver>(name, driver, Devices.remoteSession());
    }

    public static <Driver extends WebDriver> Device<Driver> directDevice(String name, Driver driver) {
        return new Device<Driver>(name, driver, Devices.fixedSession());
    }

    public static <Driver extends WebDriver> DeviceProvider<Driver> provider(Supplier<Device<Driver>> supplier) {
        return supplier::get;
    }

    public static <Driver extends WebDriver> DeviceProvider<Driver> provider(String device, Supplier<Driver> supplier, Function<Driver, SessionId> session) {
        return () -> new Device<WebDriver>(device, (WebDriver)supplier.get(), session);
    }

    public static <Driver extends WebDriver> DeviceProvider<Driver> directProvider(String device, Supplier<Driver> supplier) {
        return () -> Devices.directDevice(device, (WebDriver)supplier.get());
    }

    public static <Driver extends RemoteWebDriver> DeviceProvider<Driver> remoteProvider(String device, Supplier<Driver> supplier) {
        return () -> Devices.remoteDevice(device, (RemoteWebDriver)supplier.get());
    }
}

