/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.device;

import io.webdevice.device.Device;
import io.webdevice.device.DeviceNotProvidedException;
import io.webdevice.device.DeviceRegistry;
import io.webdevice.device.Devices;
import io.webdevice.device.WebDevice;
import io.webdevice.support.RelativeNavigation;
import io.webdevice.test.UnitTest;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.openqa.selenium.By;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.interactions.Interactive;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebElement;

public class WebDeviceTest
extends UnitTest {
    @Mock
    private DeviceRegistry mockDeviceRegistry;
    @Mock
    private WebDriver.TargetLocator mockTargetLocator;
    @Mock
    private WebDriver.Navigation mockNavigation;
    @Mock
    private WebDriver.Options mockOptions;
    @Mock(extraInterfaces={JavascriptExecutor.class, HasCapabilities.class, Interactive.class, TakesScreenshot.class})
    private WebDriver mockWebDriver;
    private Device<WebDriver> device;
    @Mock(extraInterfaces={JavascriptExecutor.class, HasCapabilities.class, Interactive.class, TakesScreenshot.class})
    private WebDriver mockWebDriver2;
    private Device<WebDriver> device2;
    private WebDevice webDevice;
    @Mock
    private Consumer<WebDriver> mockConsumer;
    @Mock
    private Function<WebDriver, WebDevice> mockFunction;

    @Before
    public void setUp() throws Exception {
        BDDMockito.given((Object)this.mockWebDriver.navigate()).willReturn((Object)this.mockNavigation);
        BDDMockito.given((Object)this.mockWebDriver.switchTo()).willReturn((Object)this.mockTargetLocator);
        BDDMockito.given((Object)this.mockWebDriver.manage()).willReturn((Object)this.mockOptions);
        this.device = Devices.directDevice((String)"iphone", (WebDriver)this.mockWebDriver);
        this.device2 = Devices.directDevice((String)"ipad", (WebDriver)this.mockWebDriver2);
        this.webDevice = new WebDevice(this.mockDeviceRegistry).withBaseUrl(new URL("http://localhost"));
    }

    @Test
    public void fluentBuildersShouldPopulateProperties() throws Exception {
        this.webDevice.withBaseUrl(new URL("http://remotehost")).withDefaultDevice("iphone").withEager(true).withStrict(true);
        Assertions.assertThat((URL)this.webDevice.getBaseUrl()).isEqualTo((Object)new URL("http://remotehost"));
        Assertions.assertThat((String)this.webDevice.getDefaultDevice()).isEqualTo("iphone");
        Assertions.assertThat((boolean)this.webDevice.isEager()).isEqualTo(true);
        Assertions.assertThat((boolean)this.webDevice.isStrict()).isEqualTo(true);
    }

    @Test
    public void shouldCanonicalizeUrls() throws Exception {
        Assertions.assertThat((String)this.webDevice.canonicalize("http://remotehost")).isEqualTo("http://remotehost");
        Assertions.assertThat((String)this.webDevice.canonicalize("foo")).isEqualTo("http://localhost/foo");
        Assertions.assertThat((String)this.webDevice.canonicalize("/foo")).isEqualTo("http://localhost/foo");
        this.webDevice.withBaseUrl(new URL("http://localhost/"));
        Assertions.assertThat((String)this.webDevice.canonicalize("foo")).isEqualTo("http://localhost/foo");
        Assertions.assertThat((String)this.webDevice.canonicalize("/foo")).isEqualTo("http://localhost/foo");
    }

    @Test
    public void initializeShouldAcquireDefaultDevice() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        Assertions.assertThat((Object)this.webDevice.device()).isSameAs(this.device);
    }

    @Test
    public void initializeShouldNotAcquireDefaultDevice() {
        this.initializeWith("iphone", false, true);
        Assertions.assertThat((boolean)this.webDevice.acquired()).isFalse();
    }

    @Test
    public void useShouldRaiseExceptionWhenStrictAndDeviceAlreadyAcquired() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        Assertions.assertThat((boolean)this.webDevice.acquired()).isTrue();
        try {
            this.webDevice.use("iphone");
            Assertions.fail((String)"Expected an exception");
        }
        catch (IllegalStateException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Browser has already been acquired for the current scenario");
        }
    }

    @Test
    public void useShouldReleaseDeviceWhenNotStrictAndDeviceAlreadyAcquired() {
        this.providing("iphone", this.device).providing("ipad", this.device2).initializeWith("iphone", true, false);
        Assertions.assertThat((Object)this.webDevice.device()).isSameAs(this.device);
        WebDevice fluent = this.webDevice.use("ipad");
        Assertions.assertThat((Object)fluent).isSameAs((Object)this.webDevice);
        Assertions.assertThat((Object)this.webDevice.device()).isSameAs(this.device2);
        ((DeviceRegistry)Mockito.verify((Object)this.mockDeviceRegistry)).release(this.device);
    }

    @Test
    public void useDefaultShouldAcquireDefaultDevice() {
        this.providing("iphone", this.device).initializeWith("iphone", false, true);
        Assertions.assertThat((boolean)this.webDevice.acquired()).isFalse();
        WebDevice fluent = this.webDevice.useDefault();
        Assertions.assertThat((Object)fluent).isSameAs((Object)this.webDevice);
        Assertions.assertThat((Object)this.webDevice.device()).isSameAs(this.device);
    }

    @Test
    public void homeShouldNavigateToBaseUrl() throws Exception {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        WebDevice fluent = this.webDevice.home();
        Assertions.assertThat((Object)fluent).isSameAs((Object)this.webDevice);
        ((WebDriver.Navigation)Mockito.verify((Object)this.mockNavigation)).to(new URL("http://localhost"));
    }

    @Test
    public void navigateToShouldCanonicalizeRelativeUrl() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        WebDevice fluent = this.webDevice.navigateTo("/foo");
        Assertions.assertThat((Object)fluent).isSameAs((Object)this.webDevice);
        ((WebDriver.Navigation)Mockito.verify((Object)this.mockNavigation)).to("http://localhost/foo");
    }

    @Test
    public void navigateToShouldNotCanonicalizeAbsoluteUrl() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        WebDevice fluent = this.webDevice.navigateTo("http://remotehost/foo");
        Assertions.assertThat((Object)fluent).isSameAs((Object)this.webDevice);
        ((WebDriver.Navigation)Mockito.verify((Object)this.mockNavigation)).to("http://remotehost/foo");
    }

    @Test
    public void performShouldExecuteWithDriver() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        WebDevice fluent = this.webDevice.perform(this.mockConsumer);
        Assertions.assertThat((Object)fluent).isSameAs((Object)this.webDevice);
        ((Consumer)Mockito.verify(this.mockConsumer)).accept(this.mockWebDriver);
    }

    @Test
    public void invokeShouldExecuteWithDriver() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        BDDMockito.given((Object)this.mockFunction.apply(this.mockWebDriver)).willReturn((Object)this.webDevice);
        WebDevice fluent = (WebDevice)this.webDevice.invoke(this.mockFunction);
        Assertions.assertThat((Object)fluent).isSameAs((Object)this.webDevice);
        ((Function)Mockito.verify(this.mockFunction)).apply(this.mockWebDriver);
    }

    @Test
    public void getCapabilitiesShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        DesiredCapabilities expected = DesiredCapabilities.iphone();
        BDDMockito.given((Object)((HasCapabilities)this.mockWebDriver).getCapabilities()).willReturn((Object)expected);
        Assertions.assertThat((Object)this.webDevice.getCapabilities()).isSameAs((Object)expected);
    }

    @Test
    public void executeScriptShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        Object expected = new Object();
        BDDMockito.given((Object)((JavascriptExecutor)this.mockWebDriver).executeScript("script", new Object[]{"arg"})).willReturn(expected);
        Assertions.assertThat((Object)this.webDevice.executeScript("script", new Object[]{"arg"})).isSameAs(expected);
    }

    @Test
    public void executeAsyncScriptShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        Object expected = new Object();
        BDDMockito.given((Object)((JavascriptExecutor)this.mockWebDriver).executeAsyncScript("script", new Object[]{"arg"})).willReturn(expected);
        Assertions.assertThat((Object)this.webDevice.executeAsyncScript("script", new Object[]{"arg"})).isSameAs(expected);
    }

    @Test
    public void getScreenshotAsShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        String expected = "encoded";
        BDDMockito.given((Object)((String)((TakesScreenshot)this.mockWebDriver).getScreenshotAs(OutputType.BASE64))).willReturn((Object)expected);
        Assertions.assertThat((String)((String)this.webDevice.getScreenshotAs(OutputType.BASE64))).isSameAs((Object)expected);
    }

    @Test
    public void getShouldDelegateAndCanonicalizeRelativeUrl() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        this.webDevice.get("/foo");
        ((WebDriver)Mockito.verify((Object)this.mockWebDriver)).get("http://localhost/foo");
    }

    @Test
    public void getShouldDelegateAndNotCanonicalizeAbsoluteUrl() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        this.webDevice.get("http://remotehost/foo");
        ((WebDriver)Mockito.verify((Object)this.mockWebDriver)).get("http://remotehost/foo");
    }

    @Test
    public void getCurrentUrlShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        String expected = "http://localhost/foo";
        BDDMockito.given((Object)this.mockWebDriver.getCurrentUrl()).willReturn((Object)expected);
        Assertions.assertThat((String)this.webDevice.getCurrentUrl()).isSameAs((Object)expected);
    }

    @Test
    public void getTitleShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        String expected = "Foo";
        BDDMockito.given((Object)this.mockWebDriver.getTitle()).willReturn((Object)expected);
        Assertions.assertThat((String)this.webDevice.getTitle()).isSameAs((Object)expected);
    }

    @Test
    public void findElementsShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        By by = By.cssSelector((String)"#id");
        List expected = Collections.emptyList();
        BDDMockito.given((Object)this.mockWebDriver.findElements(by)).willReturn(expected);
        Assertions.assertThat((List)this.webDevice.findElements(by)).isSameAs(expected);
    }

    @Test
    public void findElementShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        By by = By.cssSelector((String)"#id");
        RemoteWebElement expected = new RemoteWebElement();
        BDDMockito.given((Object)this.mockWebDriver.findElement(by)).willReturn((Object)expected);
        Assertions.assertThat((Object)this.webDevice.findElement(by)).isSameAs((Object)expected);
    }

    @Test
    public void getPageSourceShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        String expected = "<html/>";
        BDDMockito.given((Object)this.mockWebDriver.getPageSource()).willReturn((Object)expected);
        Assertions.assertThat((String)this.webDevice.getPageSource()).isSameAs((Object)expected);
    }

    @Test
    public void closeShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        this.webDevice.close();
        ((WebDriver)Mockito.verify((Object)this.mockWebDriver)).close();
    }

    @Test
    public void quiteShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        this.webDevice.quit();
        ((WebDriver)Mockito.verify((Object)this.mockWebDriver)).quit();
    }

    @Test
    public void getWindowHandlesShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        Set expected = Collections.emptySet();
        BDDMockito.given((Object)this.mockWebDriver.getWindowHandles()).willReturn(expected);
        Assertions.assertThat((Iterable)this.webDevice.getWindowHandles()).isSameAs(expected);
    }

    @Test
    public void getWindowHandleShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        String expected = "window-handle";
        BDDMockito.given((Object)this.mockWebDriver.getWindowHandle()).willReturn((Object)expected);
        Assertions.assertThat((String)this.webDevice.getWindowHandle()).isSameAs((Object)expected);
    }

    @Test
    public void switchToShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        Assertions.assertThat((Object)this.webDevice.switchTo()).isSameAs((Object)this.mockTargetLocator);
    }

    @Test
    public void navigateShouldDelegateAndWrapResultWithRelativeNavigation() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        WebDriver.Navigation navigate = this.webDevice.navigate();
        navigate.to("/foo");
        Assertions.assertThat((Object)navigate).isInstanceOf(RelativeNavigation.class);
        ((WebDriver)Mockito.verify((Object)this.mockWebDriver)).navigate();
        ((WebDriver.Navigation)Mockito.verify((Object)this.mockNavigation)).to("http://localhost/foo");
    }

    @Test
    public void manageShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        Assertions.assertThat((Object)this.webDevice.manage()).isSameAs((Object)this.mockOptions);
    }

    @Test
    public void performActionsShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        Set actions = Collections.emptySet();
        this.webDevice.perform(actions);
        ((Interactive)Mockito.verify((Object)((Interactive)this.mockWebDriver))).perform(actions);
    }

    @Test
    public void resetInputStateShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        this.webDevice.resetInputState();
        ((Interactive)Mockito.verify((Object)((Interactive)this.mockWebDriver))).resetInputState();
    }

    @Test
    public void releaseShouldNotFailWhenDeviceHasNotBeenAcquired() {
        Assertions.assertThat((boolean)this.webDevice.acquired()).isFalse();
        this.webDevice.release();
        Assertions.assertThat((boolean)this.webDevice.acquired()).isFalse();
    }

    @Test
    public void releaseShouldReleaseDeviceAndClearReferenceWhenOneHasBeenAcquired() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        Assertions.assertThat((boolean)this.webDevice.acquired()).isTrue();
        this.webDevice.release();
        Assertions.assertThat((boolean)this.webDevice.acquired()).isFalse();
        ((DeviceRegistry)Mockito.verify((Object)this.mockDeviceRegistry)).release(this.device);
    }

    @Test
    public void releaseShouldClearDeviceReferenceWhenExceptionIsRaisedReleasingToRegistry() {
        this.providing("iphone", this.device).initializeWith("iphone", true, false);
        Assertions.assertThat((boolean)this.webDevice.acquired()).isTrue();
        ((DeviceRegistry)BDDMockito.willThrow((Throwable[])new Throwable[]{new DeviceNotProvidedException("iphone")}).given((Object)this.mockDeviceRegistry)).release(this.device);
        try {
            this.webDevice.release();
            Assertions.fail((String)"Expected an exception");
        }
        catch (DeviceNotProvidedException deviceNotProvidedException) {
            // empty catch block
        }
        Assertions.assertThat((boolean)this.webDevice.acquired()).isFalse();
        ((DeviceRegistry)Mockito.verify((Object)this.mockDeviceRegistry)).release(this.device);
    }

    private WebDeviceTest providing(String name, Device<WebDriver> device) {
        BDDMockito.given((Object)this.mockDeviceRegistry.provide(name)).willReturn(device);
        return this;
    }

    private WebDeviceTest initializeWith(String defaultDevice, boolean eager, boolean strict) {
        this.webDevice.withDefaultDevice(defaultDevice).withEager(eager).withStrict(strict).initialize();
        return this;
    }
}

