/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.support;

import io.webdevice.device.Device;
import io.webdevice.device.DeviceNotProvidedException;
import io.webdevice.device.DeviceProvider;
import io.webdevice.device.DeviceRegistry;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openqa.selenium.WebDriver;

public class SimpleDeviceRegistry
implements DeviceRegistry {
    private final Map<String, DeviceProvider<? extends WebDriver>> providers = new LinkedHashMap<String, DeviceProvider<? extends WebDriver>>();

    public <Driver extends WebDriver> SimpleDeviceRegistry withProvider(String device, DeviceProvider<Driver> provider) {
        this.providers.put(device, provider);
        return this;
    }

    @Override
    public <Driver extends WebDriver> Device<Driver> provide(String device) {
        DeviceProvider<Driver> provider = this.providerOf(device);
        return (Device)provider.get();
    }

    @Override
    public <Driver extends WebDriver> void release(Device<Driver> device) {
        DeviceProvider<Driver> provider = this.providerOf(device.getName());
        provider.accept(device);
    }

    private <Driver extends WebDriver> DeviceProvider<Driver> providerOf(String device) {
        DeviceProvider<? extends WebDriver> provider = this.providers.get(device);
        if (provider == null) {
            throw new DeviceNotProvidedException(device);
        }
        return provider;
    }
}

