/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.support;

import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;

public class ProtectedCapabilities
extends MutableCapabilities {
    private static final String MASK = "********";
    private final Set<String> confidential;

    public ProtectedCapabilities(Capabilities other, Set<String> confidential) {
        super(other);
        this.confidential = confidential;
    }

    public static String mask(Capabilities capabilities, Set<String> confidential) {
        return new ProtectedCapabilities(capabilities, confidential).toString();
    }

    public String toString() {
        return this.mask(new IdentityHashMap<Object, String>(), this.asMap());
    }

    private String mask(Map<Object, String> seen, Object stringify) {
        if (stringify == null) {
            return "null";
        }
        StringBuilder value = new StringBuilder();
        if (stringify.getClass().isArray()) {
            value.append("[");
            value.append(Stream.of((Object[])stringify).map(item -> this.mask(seen, item)).collect(Collectors.joining(", ")));
            value.append("]");
        } else if (stringify instanceof Collection) {
            value.append("[");
            value.append(((Collection)stringify).stream().map(item -> this.mask(seen, item)).collect(Collectors.joining(", ")));
            value.append("]");
        } else if (stringify instanceof Map) {
            value.append("{");
            value.append(((Map)stringify).entrySet().stream().sorted(Comparator.comparing(entry -> String.valueOf(entry.getKey()))).map(entry -> entry.getKey() + ": " + (!this.confidential.contains(entry.getKey()) ? this.mask(seen, entry.getValue()) : MASK)).collect(Collectors.joining(", ")));
            value.append("}");
        } else if (stringify instanceof Capabilities) {
            value.append("{");
            value.append(((Capabilities)stringify).asMap().entrySet().stream().sorted(Comparator.comparing(entry -> String.valueOf(entry.getKey()))).map(entry -> (String)entry.getKey() + ": " + (!this.confidential.contains(entry.getKey()) ? this.mask(seen, entry.getValue()) : MASK)).collect(Collectors.joining(", ")));
            value.append("}");
        } else {
            String s = String.valueOf(stringify);
            if (s.length() > 30) {
                value.append(s.substring(0, 27)).append("...");
            } else {
                value.append(s);
            }
        }
        seen.put(stringify, value.toString());
        return value.toString();
    }
}

