/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.device;

import io.webdevice.device.BaseDeviceProvider;
import io.webdevice.device.Device;
import io.webdevice.device.Devices;
import io.webdevice.support.ProtectedWebDriver;
import java.net.URL;
import java.util.Set;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class RemoteDeviceProvider
extends BaseDeviceProvider<RemoteWebDriver> {
    private final URL remoteAddress;

    public RemoteDeviceProvider(String name, URL remoteAddress) {
        super(name);
        this.remoteAddress = remoteAddress;
    }

    public URL getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public void initialize() {
        if (this.capabilities == null) {
            this.capabilities = new ImmutableCapabilities();
        }
    }

    @Override
    public Device<RemoteWebDriver> get() {
        this.log.info("Providing new device named {} connecting to {} with capabilities {}", new Object[]{this.name, this.remoteAddress, this.maskedCapabilities()});
        return Devices.remoteDevice(this.name, new ProtectedWebDriver(this.remoteAddress, this.capabilities, (Set<String>)this.confidential));
    }
}

