/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.device;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.SessionId;

public class Device<Driver extends WebDriver> {
    private final String name;
    private final Driver driver;
    private final Function<Driver, SessionId> session;

    public Device(String name, Driver driver, Function<Driver, SessionId> session) {
        this.name = name;
        this.driver = driver;
        this.session = session;
    }

    public String getName() {
        return this.name;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public <T> T as(Class<T> type) {
        return type.cast(this.driver);
    }

    public SessionId getSessionId() {
        return this.session.apply(this.driver);
    }

    public Device<Driver> perform(Consumer<Driver> consumer) {
        consumer.accept(this.driver);
        return this;
    }

    public <R> R invoke(Function<Driver, R> function) {
        return function.apply(this.driver);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Device that = (Device)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.driver.getClass(), that.driver.getClass()) && Objects.equals(this.getSessionId(), that.getSessionId());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.driver.getClass(), this.getSessionId());
    }
}

