/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.device;

import io.webdevice.device.RemoteDeviceProvider;
import io.webdevice.test.UnitTest;
import java.net.URL;
import java.util.Collections;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.remote.DesiredCapabilities;

public class RemoteDeviceProviderTest
extends UnitTest {
    @Mock
    private Appender mockAppender;
    @Captor
    private ArgumentCaptor<LoggingEvent> loggingEventCaptor;
    private URL remoteAddress;
    private MockWebServer mockWebServer;
    private RemoteDeviceProvider provider;

    @Before
    public void setUp() throws Exception {
        Logger.getLogger(RemoteDeviceProvider.class).addAppender(this.mockAppender);
        this.mockWebServer = new MockWebServer();
        this.mockWebServer.start();
        this.remoteAddress = this.mockWebServer.url("").url();
        this.provider = new RemoteDeviceProvider("iphone", this.remoteAddress);
    }

    @After
    public void tearDown() {
        Logger.getLogger(RemoteDeviceProvider.class).removeAppender(this.mockAppender);
    }

    @Test
    public void shouldTakeNameAndRemoteAddressFromConstructor() {
        Assertions.assertThat((String)this.provider.getName()).isEqualTo("iphone");
        Assertions.assertThat((URL)this.provider.getRemoteAddress()).isEqualTo((Object)this.remoteAddress);
    }

    @Test
    public void initializeShouldSetImmutableCapabilitiesIfNoneProvided() {
        Assertions.assertThat((Object)this.provider.getCapabilities()).isNull();
        this.provider.initialize();
        Assertions.assertThat((Object)this.provider.getCapabilities()).isInstanceOf(ImmutableCapabilities.class);
    }

    @Test
    public void initializeShouldNotSetImmutableCapabilitiesIfProvided() {
        DesiredCapabilities capabilities = DesiredCapabilities.iphone();
        this.provider.setCapabilities((Capabilities)capabilities);
        this.provider.initialize();
        Assertions.assertThat((Object)this.provider.getCapabilities()).isSameAs((Object)capabilities);
    }

    @Test
    public void getShouldProtectCapabilitiesWhenLogging() {
        MutableCapabilities capabilities = new MutableCapabilities();
        capabilities.setCapability("accessKey", "2secret4u");
        this.provider.setCapabilities((Capabilities)capabilities);
        this.provider.setConfidential(Collections.singleton("accessKey"));
        this.provider.initialize();
        this.mockWebServer.enqueue(new MockResponse().setBody("{\"status\": 0, \"sessionId\": \"aa\", \"value\": {}}"));
        this.provider.get();
        ((Appender)Mockito.verify((Object)this.mockAppender)).doAppend((LoggingEvent)this.loggingEventCaptor.capture());
        Assertions.assertThat((Object)((LoggingEvent)this.loggingEventCaptor.getValue()).getMessage()).isEqualTo((Object)String.format("Providing new device named iphone connecting to %s with capabilities {accessKey: ********}", this.remoteAddress));
    }

    @Test
    public void disposeShouldDoNothing() {
        this.provider.dispose();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getConfidentialShouldReturnImmutableSet() {
        this.provider.getConfidential().add("foo");
    }
}

