/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.device;

import io.webdevice.device.Device;
import io.webdevice.device.DeviceProvider;
import io.webdevice.device.Devices;
import io.webdevice.test.UnitTest;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;

public class DevicesTest
extends UnitTest {
    @Mock
    private WebDriver mockWebDriver;
    @Mock
    private RemoteWebDriver mockRemoteWebDriver;

    @Test
    public void randomSessionIdShouldReturnNewSessionIdEachTime() {
        Assertions.assertThat((Object)Devices.randomSessionId()).isNotEqualTo((Object)Devices.randomSessionId());
    }

    @Test
    public void fixedSessionFunctionWithSessionIdShouldReturnSameSessionId() {
        SessionId sessionId = Devices.randomSessionId();
        Function function = Devices.fixedSession((SessionId)sessionId);
        Assertions.assertThat((Object)((SessionId)function.apply(null))).isSameAs((Object)sessionId);
        Assertions.assertThat((Object)((SessionId)function.apply(this.mockWebDriver))).isSameAs((Object)sessionId);
    }

    @Test
    public void fixedSessionFunctionShouldReturnSameSessionId() {
        Function function = Devices.fixedSession();
        SessionId sessionId = (SessionId)function.apply(null);
        Assertions.assertThat((Object)((SessionId)function.apply(this.mockWebDriver))).isSameAs((Object)sessionId);
        Assertions.assertThat((Object)((SessionId)function.apply(this.mockRemoteWebDriver))).isSameAs((Object)sessionId);
    }

    @Test
    public void remoteSessionFunctionShouldReturnSameSessionIdFromRemoteWebDriver() {
        SessionId sessionId = Devices.randomSessionId();
        BDDMockito.given((Object)this.mockRemoteWebDriver.getSessionId()).willReturn((Object)sessionId);
        Function function = Devices.remoteSession();
        Assertions.assertThat((Object)((SessionId)function.apply(this.mockRemoteWebDriver))).isSameAs((Object)sessionId);
        Assertions.assertThat((Object)((SessionId)function.apply(this.mockRemoteWebDriver))).isSameAs((Object)sessionId);
    }

    @Test
    public void directDeviceShouldCreateDeviceUsingGeneratedSessionId() {
        Device device = Devices.directDevice((String)"iphone", (WebDriver)this.mockWebDriver);
        Assertions.assertThat((String)device.getName()).isEqualTo("iphone");
        Assertions.assertThat((Object)device.getDriver()).isSameAs((Object)this.mockWebDriver);
        SessionId sessionId = device.getSessionId();
        Assertions.assertThat((Object)sessionId).isNotNull();
        Assertions.assertThat((Object)device.getSessionId()).isSameAs((Object)sessionId);
    }

    @Test
    public void remoteDeviceShouldCreateDeviceUsingSessionIdFromDriver() {
        SessionId sessionId = Devices.randomSessionId();
        BDDMockito.given((Object)this.mockRemoteWebDriver.getSessionId()).willReturn((Object)sessionId);
        Device device = Devices.remoteDevice((String)"iphone", (RemoteWebDriver)this.mockRemoteWebDriver);
        Assertions.assertThat((String)device.getName()).isEqualTo("iphone");
        Assertions.assertThat((Object)((RemoteWebDriver)device.getDriver())).isSameAs((Object)this.mockRemoteWebDriver);
        Assertions.assertThat((Object)device.getSessionId()).isSameAs((Object)sessionId);
        Assertions.assertThat((Object)device.getSessionId()).isSameAs((Object)sessionId);
    }

    @Test
    public void providerShouldCreateDevicesUsingDeviceSupplier() {
        SessionId sessionId = Devices.randomSessionId();
        BDDMockito.given((Object)this.mockRemoteWebDriver.getSessionId()).willReturn((Object)sessionId);
        Device singleton = Devices.remoteDevice((String)"iphone", (RemoteWebDriver)this.mockRemoteWebDriver);
        DeviceProvider provider = Devices.provider(() -> singleton);
        Device device = (Device)provider.get();
        Assertions.assertThat((Object)device).isSameAs((Object)singleton);
        Assertions.assertThat((String)device.getName()).isEqualTo("iphone");
        Assertions.assertThat((Object)((RemoteWebDriver)device.getDriver())).isSameAs((Object)this.mockRemoteWebDriver);
        Assertions.assertThat((Object)device.getSessionId()).isSameAs((Object)sessionId);
        Assertions.assertThat((Object)device.getSessionId()).isSameAs((Object)sessionId);
        provider.accept(device);
        ((RemoteWebDriver)Mockito.verify((Object)this.mockRemoteWebDriver)).quit();
    }

    @Test
    public void providerShouldCreateDevicesUsingNameDriverSupplierAndSessionFunction() {
        SessionId sessionId = Devices.randomSessionId();
        BDDMockito.given((Object)this.mockRemoteWebDriver.getSessionId()).willReturn((Object)sessionId);
        DeviceProvider provider = Devices.provider((String)"iphone", () -> this.mockRemoteWebDriver, (Function)Devices.remoteSession());
        Device device = (Device)provider.get();
        Assertions.assertThat((String)device.getName()).isEqualTo("iphone");
        Assertions.assertThat((Object)((RemoteWebDriver)device.getDriver())).isSameAs((Object)this.mockRemoteWebDriver);
        Assertions.assertThat((Object)device.getSessionId()).isSameAs((Object)sessionId);
        Assertions.assertThat((Object)device.getSessionId()).isSameAs((Object)sessionId);
        provider.accept(device);
        ((RemoteWebDriver)Mockito.verify((Object)this.mockRemoteWebDriver)).quit();
    }

    @Test
    public void directProviderShouldCreateDevicesUsingNameDriverSupplier() {
        DeviceProvider provider = Devices.directProvider((String)"iphone", () -> this.mockWebDriver);
        Device device = (Device)provider.get();
        Assertions.assertThat((String)device.getName()).isEqualTo("iphone");
        Assertions.assertThat((Object)device.getDriver()).isSameAs((Object)this.mockWebDriver);
        SessionId sessionId = device.getSessionId();
        Assertions.assertThat((Object)sessionId).isNotNull();
        Assertions.assertThat((Object)device.getSessionId()).isSameAs((Object)sessionId);
        provider.accept(device);
        ((WebDriver)Mockito.verify((Object)this.mockWebDriver)).quit();
    }

    @Test
    public void remoteProviderShouldCreateDevicesUsingNameDriverSupplier() {
        SessionId sessionId = Devices.randomSessionId();
        BDDMockito.given((Object)this.mockRemoteWebDriver.getSessionId()).willReturn((Object)sessionId);
        DeviceProvider provider = Devices.remoteProvider((String)"iphone", () -> this.mockRemoteWebDriver);
        Device device = (Device)provider.get();
        Assertions.assertThat((String)device.getName()).isEqualTo("iphone");
        Assertions.assertThat((Object)((RemoteWebDriver)device.getDriver())).isSameAs((Object)this.mockRemoteWebDriver);
        Assertions.assertThat((Object)device.getSessionId()).isSameAs((Object)sessionId);
        Assertions.assertThat((Object)device.getSessionId()).isSameAs((Object)sessionId);
        provider.accept(device);
        ((RemoteWebDriver)Mockito.verify((Object)this.mockRemoteWebDriver)).quit();
    }
}

