/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.device;

import io.webdevice.device.Browser;
import io.webdevice.device.Device;
import io.webdevice.device.DeviceNotProvidedException;
import io.webdevice.device.DeviceRegistry;
import io.webdevice.device.Devices;
import io.webdevice.device.WebDevice;
import io.webdevice.support.RelativeNavigation;
import io.webdevice.test.UnitTest;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.openqa.selenium.By;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.interactions.Interactive;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebElement;

public class BrowserTest
extends UnitTest {
    @Mock
    private DeviceRegistry mockDeviceRegistry;
    @Mock
    private WebDriver.TargetLocator mockTargetLocator;
    @Mock
    private WebDriver.Navigation mockNavigation;
    @Mock
    private WebDriver.Options mockOptions;
    @Mock(extraInterfaces={JavascriptExecutor.class, HasCapabilities.class, Interactive.class, TakesScreenshot.class})
    private WebDriver mockWebDriver;
    private Device<WebDriver> device;
    @Mock(extraInterfaces={JavascriptExecutor.class, HasCapabilities.class, Interactive.class, TakesScreenshot.class})
    private WebDriver mockWebDriver2;
    private Device<WebDriver> device2;
    private Browser browser;
    @Mock
    private Consumer<WebDriver> mockConsumer;
    @Mock
    private Function<WebDriver, WebDevice> mockFunction;

    @Before
    public void setUp() throws Exception {
        BDDMockito.given((Object)this.mockWebDriver.navigate()).willReturn((Object)this.mockNavigation);
        BDDMockito.given((Object)this.mockWebDriver.switchTo()).willReturn((Object)this.mockTargetLocator);
        BDDMockito.given((Object)this.mockWebDriver.manage()).willReturn((Object)this.mockOptions);
        this.device = Devices.directDevice((String)"iphone", (WebDriver)this.mockWebDriver);
        this.device2 = Devices.directDevice((String)"ipad", (WebDriver)this.mockWebDriver2);
        this.browser = new Browser(this.mockDeviceRegistry).withBaseUrl(new URL("http://localhost"));
    }

    @Test
    public void fluentBuildersShouldPopulateProperties() throws Exception {
        this.browser.withBaseUrl(new URL("http://remotehost")).withDefaultDevice("iphone").withEager(true).withStrict(true);
        Assertions.assertThat((URL)this.browser.getBaseUrl()).isEqualTo((Object)new URL("http://remotehost"));
        Assertions.assertThat((String)this.browser.getDefaultDevice()).isEqualTo("iphone");
        Assertions.assertThat((boolean)this.browser.isEager()).isEqualTo(true);
        Assertions.assertThat((boolean)this.browser.isStrict()).isEqualTo(true);
    }

    @Test
    public void shouldCanonicalizeUrls() throws Exception {
        Assertions.assertThat((String)this.browser.canonicalize("http://remotehost")).isEqualTo("http://remotehost");
        Assertions.assertThat((String)this.browser.canonicalize("foo")).isEqualTo("http://localhost/foo");
        Assertions.assertThat((String)this.browser.canonicalize("/foo")).isEqualTo("http://localhost/foo");
        this.browser.withBaseUrl(new URL("http://localhost/"));
        Assertions.assertThat((String)this.browser.canonicalize("foo")).isEqualTo("http://localhost/foo");
        Assertions.assertThat((String)this.browser.canonicalize("/foo")).isEqualTo("http://localhost/foo");
    }

    @Test
    public void initializeShouldAcquireDefaultDevice() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        Assertions.assertThat((Object)this.browser.device()).isSameAs(this.device);
    }

    @Test
    public void initializeShouldNotAcquireDefaultDevice() {
        this.initializeWith("iphone", false, true);
        Assertions.assertThat((boolean)this.browser.acquired()).isFalse();
    }

    @Test
    public void useShouldRaiseExceptionWhenStrictAndDeviceAlreadyAcquired() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        Assertions.assertThat((boolean)this.browser.acquired()).isTrue();
        try {
            this.browser.use("iphone");
            Assertions.fail((String)"Expected an exception");
        }
        catch (IllegalStateException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Browser has already been acquired for the current scenario");
        }
    }

    @Test
    public void useShouldReleaseDeviceWhenNotStrictAndDeviceAlreadyAcquired() {
        this.providing("iphone", this.device).providing("ipad", this.device2).initializeWith("iphone", true, false);
        Assertions.assertThat((Object)this.browser.device()).isSameAs(this.device);
        this.browser.use("ipad");
        Assertions.assertThat((Object)this.browser.device()).isSameAs(this.device2);
        ((DeviceRegistry)Mockito.verify((Object)this.mockDeviceRegistry)).release(this.device);
    }

    @Test
    public void useDefaultShouldAcquireDefaultDevice() {
        this.providing("iphone", this.device).initializeWith("iphone", false, true);
        Assertions.assertThat((boolean)this.browser.acquired()).isFalse();
        this.browser.useDefault();
        Assertions.assertThat((Object)this.browser.device()).isSameAs(this.device);
    }

    @Test
    public void homeShouldNavigateToBaseUrl() throws Exception {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        this.browser.home();
        ((WebDriver.Navigation)Mockito.verify((Object)this.mockNavigation)).to(new URL("http://localhost"));
    }

    @Test
    public void navigateToShouldCanonicalizeRelativeUrl() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        this.browser.navigateTo("/foo");
        ((WebDriver.Navigation)Mockito.verify((Object)this.mockNavigation)).to("http://localhost/foo");
    }

    @Test
    public void navigateToShouldNotCanonicalizeAbsoluteUrl() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        this.browser.navigateTo("http://remotehost/foo");
        ((WebDriver.Navigation)Mockito.verify((Object)this.mockNavigation)).to("http://remotehost/foo");
    }

    @Test
    public void performShouldExecuteWithDriver() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        this.browser.perform(this.mockConsumer);
        ((Consumer)Mockito.verify(this.mockConsumer)).accept(this.mockWebDriver);
    }

    @Test
    public void invokeShouldExecuteWithDriver() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        BDDMockito.given((Object)this.mockFunction.apply(this.mockWebDriver)).willReturn((Object)this.browser);
        WebDevice fluent = (WebDevice)this.browser.invoke(this.mockFunction);
        Assertions.assertThat((Object)fluent).isSameAs((Object)this.browser);
        ((Function)Mockito.verify(this.mockFunction)).apply(this.mockWebDriver);
    }

    @Test
    public void getCapabilitiesShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        DesiredCapabilities expected = DesiredCapabilities.iphone();
        BDDMockito.given((Object)((HasCapabilities)this.mockWebDriver).getCapabilities()).willReturn((Object)expected);
        Assertions.assertThat((Object)this.browser.getCapabilities()).isSameAs((Object)expected);
    }

    @Test
    public void executeScriptShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        Object expected = new Object();
        BDDMockito.given((Object)((JavascriptExecutor)this.mockWebDriver).executeScript("script", new Object[]{"arg"})).willReturn(expected);
        Assertions.assertThat((Object)this.browser.executeScript("script", new Object[]{"arg"})).isSameAs(expected);
    }

    @Test
    public void executeAsyncScriptShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        Object expected = new Object();
        BDDMockito.given((Object)((JavascriptExecutor)this.mockWebDriver).executeAsyncScript("script", new Object[]{"arg"})).willReturn(expected);
        Assertions.assertThat((Object)this.browser.executeAsyncScript("script", new Object[]{"arg"})).isSameAs(expected);
    }

    @Test
    public void getScreenshotAsShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        String expected = "encoded";
        BDDMockito.given((Object)((String)((TakesScreenshot)this.mockWebDriver).getScreenshotAs(OutputType.BASE64))).willReturn((Object)expected);
        Assertions.assertThat((String)((String)this.browser.getScreenshotAs(OutputType.BASE64))).isSameAs((Object)expected);
    }

    @Test
    public void getShouldDelegateAndCanonicalizeRelativeUrl() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        this.browser.get("/foo");
        ((WebDriver)Mockito.verify((Object)this.mockWebDriver)).get("http://localhost/foo");
    }

    @Test
    public void getShouldDelegateAndNotCanonicalizeAbsoluteUrl() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        this.browser.get("http://remotehost/foo");
        ((WebDriver)Mockito.verify((Object)this.mockWebDriver)).get("http://remotehost/foo");
    }

    @Test
    public void getCurrentUrlShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        String expected = "http://localhost/foo";
        BDDMockito.given((Object)this.mockWebDriver.getCurrentUrl()).willReturn((Object)expected);
        Assertions.assertThat((String)this.browser.getCurrentUrl()).isSameAs((Object)expected);
    }

    @Test
    public void getTitleShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        String expected = "Foo";
        BDDMockito.given((Object)this.mockWebDriver.getTitle()).willReturn((Object)expected);
        Assertions.assertThat((String)this.browser.getTitle()).isSameAs((Object)expected);
    }

    @Test
    public void findElementsShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        By by = By.cssSelector((String)"#id");
        List expected = Collections.emptyList();
        BDDMockito.given((Object)this.mockWebDriver.findElements(by)).willReturn(expected);
        Assertions.assertThat((List)this.browser.findElements(by)).isSameAs(expected);
    }

    @Test
    public void findElementShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        By by = By.cssSelector((String)"#id");
        RemoteWebElement expected = new RemoteWebElement();
        BDDMockito.given((Object)this.mockWebDriver.findElement(by)).willReturn((Object)expected);
        Assertions.assertThat((Object)this.browser.findElement(by)).isSameAs((Object)expected);
    }

    @Test
    public void getPageSourceShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        String expected = "<html/>";
        BDDMockito.given((Object)this.mockWebDriver.getPageSource()).willReturn((Object)expected);
        Assertions.assertThat((String)this.browser.getPageSource()).isSameAs((Object)expected);
    }

    @Test
    public void closeShouldDelegateWhenThereAreMultipleWindowsOpen() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        BDDMockito.given((Object)this.mockWebDriver.getWindowHandles()).willReturn(new LinkedHashSet<String>(Arrays.asList("handle-1", "handle-2")));
        this.browser.close();
        ((WebDriver)Mockito.verify((Object)this.mockWebDriver)).close();
    }

    @Test
    public void closeShouldNotDelegateWhenThereIsOneWindowOpen() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        BDDMockito.given((Object)this.mockWebDriver.getWindowHandles()).willReturn(Collections.singleton("handle"));
        this.browser.close();
        ((WebDriver)Mockito.verify((Object)this.mockWebDriver, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void quitShouldNotDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        this.browser.quit();
        ((WebDriver)Mockito.verify((Object)this.mockWebDriver, (VerificationMode)Mockito.never())).quit();
    }

    @Test
    public void getWindowHandlesShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        Set expected = Collections.emptySet();
        BDDMockito.given((Object)this.mockWebDriver.getWindowHandles()).willReturn(expected);
        Assertions.assertThat((Iterable)this.browser.getWindowHandles()).isSameAs(expected);
    }

    @Test
    public void getWindowHandleShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        String expected = "window-handle";
        BDDMockito.given((Object)this.mockWebDriver.getWindowHandle()).willReturn((Object)expected);
        Assertions.assertThat((String)this.browser.getWindowHandle()).isSameAs((Object)expected);
    }

    @Test
    public void switchToShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        Assertions.assertThat((Object)this.browser.switchTo()).isSameAs((Object)this.mockTargetLocator);
    }

    @Test
    public void navigateShouldDelegateAndWrapResultWithRelativeNavigation() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        WebDriver.Navigation navigate = this.browser.navigate();
        navigate.to("/foo");
        Assertions.assertThat((Object)navigate).isInstanceOf(RelativeNavigation.class);
        ((WebDriver)Mockito.verify((Object)this.mockWebDriver)).navigate();
        ((WebDriver.Navigation)Mockito.verify((Object)this.mockNavigation)).to("http://localhost/foo");
    }

    @Test
    public void manageShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        Assertions.assertThat((Object)this.browser.manage()).isSameAs((Object)this.mockOptions);
    }

    @Test
    public void performActionsShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        Set actions = Collections.emptySet();
        this.browser.perform(actions);
        ((Interactive)Mockito.verify((Object)((Interactive)this.mockWebDriver))).perform(actions);
    }

    @Test
    public void resetInputStateShouldDelegate() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        this.browser.resetInputState();
        ((Interactive)Mockito.verify((Object)((Interactive)this.mockWebDriver))).resetInputState();
    }

    @Test
    public void releaseShouldNotFailWhenDeviceHasNotBeenAcquired() {
        Assertions.assertThat((boolean)this.browser.acquired()).isFalse();
        this.browser.release();
        Assertions.assertThat((boolean)this.browser.acquired()).isFalse();
    }

    @Test
    public void releaseShouldReleaseDeviceAndClearReferenceWhenOneHasBeenAcquired() {
        this.providing("iphone", this.device).initializeWith("iphone", true, true);
        Assertions.assertThat((boolean)this.browser.acquired()).isTrue();
        this.browser.release();
        Assertions.assertThat((boolean)this.browser.acquired()).isFalse();
        ((DeviceRegistry)Mockito.verify((Object)this.mockDeviceRegistry)).release(this.device);
    }

    @Test
    public void releaseShouldClearDeviceReferenceWhenExceptionIsRaisedReleasingToRegistry() {
        this.providing("iphone", this.device).initializeWith("iphone", true, false);
        Assertions.assertThat((boolean)this.browser.acquired()).isTrue();
        ((DeviceRegistry)BDDMockito.willThrow((Throwable[])new Throwable[]{new DeviceNotProvidedException("iphone")}).given((Object)this.mockDeviceRegistry)).release(this.device);
        try {
            this.browser.release();
            Assertions.fail((String)"Expected an exception");
        }
        catch (DeviceNotProvidedException deviceNotProvidedException) {
            // empty catch block
        }
        Assertions.assertThat((boolean)this.browser.acquired()).isFalse();
        ((DeviceRegistry)Mockito.verify((Object)this.mockDeviceRegistry)).release(this.device);
    }

    private BrowserTest providing(String name, Device<WebDriver> device) {
        BDDMockito.given((Object)this.mockDeviceRegistry.provide(name)).willReturn(device);
        return this;
    }

    private BrowserTest initializeWith(String defaultDevice, boolean eager, boolean strict) {
        this.browser.withDefaultDevice(defaultDevice).withEager(eager).withStrict(strict).initialize();
        return this;
    }
}

