/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.device;

import io.webdevice.device.Device;
import io.webdevice.device.DeviceProvider;
import java.util.Deque;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Predicate;
import javax.annotation.PreDestroy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.SessionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevicePool<Driver extends WebDriver>
implements DeviceProvider<Driver> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final BlockingDeque<Device<Driver>> free;
    private final BlockingDeque<Device<Driver>> used;
    private final String name;
    private final DeviceProvider<Driver> provider;
    private final Predicate<Device<Driver>> usable;

    protected DevicePool(String name, DeviceProvider<Driver> provider, Predicate<Device<Driver>> usable, BlockingDeque<Device<Driver>> free, BlockingDeque<Device<Driver>> used) {
        this.name = name;
        this.provider = provider;
        this.usable = usable;
        this.free = free;
        this.used = used;
    }

    public DevicePool(String name, DeviceProvider<Driver> provider, Predicate<Device<Driver>> usable) {
        this(name, provider, usable, new LinkedBlockingDeque<Device<Driver>>(), new LinkedBlockingDeque<Device<Driver>>());
    }

    @Override
    public synchronized Device<Driver> get() {
        Device<Driver> device = this.free.poll();
        if (device == null) {
            device = this.create();
        } else if (!this.usable.test(device)) {
            this.log.info("Device {} in {} pool is not usable", (Object)device.getSessionId(), (Object)this.name);
            this.release(device);
            device = this.create();
        }
        this.used.push(device);
        this.log.info("Acquired {} in {} pool", (Object)device.getSessionId(), (Object)this.name);
        this.logStats();
        return device;
    }

    @Override
    public synchronized void accept(Device<Driver> device) {
        this.log.info("Removing device {} from used deque in {} pool", (Object)device.getSessionId(), (Object)this.name);
        if (this.used.remove(device)) {
            this.log.info("Placing device {} to free deque in {} pool", (Object)device.getSessionId(), (Object)this.name);
            this.free.push(device);
        } else {
            this.log.warn("Device {} was not in used deque in {} pool!", (Object)device.getSessionId(), (Object)this.name);
        }
        this.logStats();
    }

    @PreDestroy
    public synchronized void dispose() {
        this.log.info("Shutting down {} pool...", (Object)this.name);
        this.drain(this.free);
        this.drain(this.used);
        this.log.info("Pool {} shut down.", (Object)this.name);
    }

    private Device<Driver> create() {
        this.log.info("Obtaining new device from provider {}...", (Object)this.name);
        Device device = (Device)this.provider.get();
        this.log.info("Obtained new device {} from provider {}.", (Object)device.getSessionId(), (Object)this.name);
        return device;
    }

    private void release(Device<Driver> device) {
        SessionId sessionId = device.getSessionId();
        this.log.info("Releasing {} from use in {} pool", (Object)device.getSessionId(), (Object)this.name);
        try {
            this.provider.accept(device);
        }
        catch (Exception e) {
            this.log.warn(String.format("Failure releasing device %s from %s pool", sessionId, this.name), (Throwable)e);
        }
    }

    private void drain(Deque<Device<Driver>> devices) {
        Device<Driver> device = devices.poll();
        while (device != null) {
            this.release(device);
            device = devices.poll();
        }
    }

    private void logStats() {
        this.log.info("DevicePool: {}, Free: {}, Used: {}", new Object[]{this.name, this.free.size(), this.used.size()});
    }
}

