/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.device;

import io.webdevice.device.Device;
import io.webdevice.device.DeviceRegistry;
import io.webdevice.device.WebDevice;
import io.webdevice.support.RelativeNavigation;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Interactive;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.remote.SessionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Browser
implements WebDevice {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DeviceRegistry registry;
    private URL baseUrl;
    private String defaultDevice;
    private boolean eager = false;
    private boolean strict = true;
    private Device<?> device;

    public Browser(DeviceRegistry registry) {
        this.registry = registry;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    public Browser withBaseUrl(URL baseUrl) {
        this.setBaseUrl(baseUrl);
        return this;
    }

    public String getDefaultDevice() {
        return this.defaultDevice;
    }

    public void setDefaultDevice(String defaultDevice) {
        this.defaultDevice = defaultDevice;
    }

    public Browser withDefaultDevice(String defaultDevice) {
        this.setDefaultDevice(defaultDevice);
        return this;
    }

    public boolean isEager() {
        return this.eager;
    }

    public void setEager(boolean eager) {
        this.eager = eager;
    }

    public Browser withEager(boolean eager) {
        this.setEager(eager);
        return this;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public Browser withStrict(boolean strict) {
        this.setStrict(strict);
        return this;
    }

    @PostConstruct
    public void initialize() {
        this.log.info("Initializing WebDevice...");
        if (this.eager) {
            this.log.info("Eagerly acquiring default device");
            this.useDefault();
        }
        this.log.info("WebDevice initialized.");
    }

    @Override
    public boolean acquired() {
        return this.device != null;
    }

    @Override
    public void use(String name) {
        if (this.device != null) {
            if (this.strict) {
                throw new IllegalStateException("Browser has already been acquired for the current scenario");
            }
            this.release();
        }
        this.log.info("Acquiring {} browser...", (Object)name);
        this.device = this.registry.provide(name);
        this.log.info("Acquired {} browser {}", (Object)name, (Object)this.device.getSessionId());
    }

    @Override
    public void useDefault() {
        this.use(this.defaultDevice);
    }

    @Override
    public String canonicalize(String url) {
        if (!url.contains("://")) {
            String root = this.baseUrl.toExternalForm();
            if (root.endsWith("/")) {
                if (url.startsWith("/")) {
                    return root.concat(url.substring(1));
                }
                return root.concat(url);
            }
            if (url.startsWith("/")) {
                return root.concat(url);
            }
            return root.concat("/").concat(url);
        }
        return url;
    }

    @Override
    public void home() {
        this.device.perform((Driver driver) -> driver.navigate().to(this.baseUrl));
    }

    @Override
    public void navigateTo(String relativePath) {
        this.device.perform((Driver driver) -> driver.navigate().to(this.canonicalize(relativePath)));
    }

    @Override
    public <Driver extends WebDriver> void perform(Consumer<Driver> consumer) {
        consumer.accept(this.device.getDriver());
    }

    @Override
    public <Driver extends WebDriver, R> R invoke(Function<Driver, R> function) {
        return function.apply(this.device.getDriver());
    }

    public Capabilities getCapabilities() {
        return this.device.as(HasCapabilities.class).getCapabilities();
    }

    public Object executeScript(String script, Object ... args) {
        return this.device.as(JavascriptExecutor.class).executeScript(script, args);
    }

    public Object executeAsyncScript(String script, Object ... args) {
        return this.device.as(JavascriptExecutor.class).executeAsyncScript(script, args);
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        return (X)this.device.as(TakesScreenshot.class).getScreenshotAs(target);
    }

    public void get(String url) {
        this.device.as(WebDriver.class).get(this.canonicalize(url));
    }

    public String getCurrentUrl() {
        return this.device.as(WebDriver.class).getCurrentUrl();
    }

    public String getTitle() {
        return this.device.as(WebDriver.class).getTitle();
    }

    public List<WebElement> findElements(By by) {
        return this.device.as(WebDriver.class).findElements(by);
    }

    public WebElement findElement(By by) {
        return this.device.as(WebDriver.class).findElement(by);
    }

    public String getPageSource() {
        return this.device.as(WebDriver.class).getPageSource();
    }

    public void close() {
        if (this.getWindowHandles().size() > 1) {
            this.device.as(WebDriver.class).close();
        } else {
            this.log.warn("Only the provider of the current device should manage the driver's lifecycle");
        }
    }

    public void quit() {
        this.log.warn("Only the provider of the current device should manage the driver's lifecycle");
    }

    public Set<String> getWindowHandles() {
        return this.device.as(WebDriver.class).getWindowHandles();
    }

    public String getWindowHandle() {
        return this.device.as(WebDriver.class).getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.device.as(WebDriver.class).switchTo();
    }

    public WebDriver.Navigation navigate() {
        WebDriver.Navigation navigation = this.device.as(WebDriver.class).navigate();
        return new RelativeNavigation(navigation, this::canonicalize);
    }

    public WebDriver.Options manage() {
        return this.device.as(WebDriver.class).manage();
    }

    public void perform(Collection<Sequence> actions) {
        this.device.as(Interactive.class).perform(actions);
    }

    public void resetInputState() {
        this.device.as(Interactive.class).resetInputState();
    }

    @Override
    @PreDestroy
    public void release() {
        try {
            this.log.info("Releasing WebDevice ...");
            if (this.device != null) {
                String name = this.device.getName();
                SessionId sessionId = this.device.getSessionId();
                this.log.info("Releasing {} device {}...", (Object)name, (Object)sessionId);
                this.registry.release(this.device);
                this.log.info("{} device {} released.", (Object)name, (Object)sessionId);
            }
            this.log.info("WebDevice released.");
        }
        finally {
            this.device = null;
        }
    }

    Device<?> device() {
        return this.device;
    }
}

