/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.device;

import io.webdevice.device.DeviceProvider;
import io.webdevice.support.ProtectedCapabilities;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDeviceProvider<Driver extends WebDriver>
implements DeviceProvider<Driver> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Set<String> confidential = new LinkedHashSet<String>();
    protected final String name;
    protected Capabilities capabilities;

    protected BaseDeviceProvider(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    public Collection<String> getConfidential() {
        return Collections.unmodifiableSet(this.confidential);
    }

    public void setConfidential(Collection<String> confidential) {
        this.confidential.clear();
        this.confidential.addAll(confidential);
    }

    protected String maskedCapabilities() {
        return ProtectedCapabilities.mask(this.capabilities, this.confidential);
    }
}

