/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.support;

import io.webdevice.device.Device;
import io.webdevice.device.Devices;
import io.webdevice.support.SimpleDeviceCheck;
import io.webdevice.test.UnitTest;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public class SimpleDeviceCheckTest
extends UnitTest {
    private SimpleDeviceCheck<WebDriver> check;
    @Mock
    private WebDriver mockWebDriver;
    private Device<WebDriver> device;

    @Before
    public void setUp() {
        this.check = new SimpleDeviceCheck();
        this.device = new Device("iphone", this.mockWebDriver, Devices.fixedSession());
    }

    @Test
    public void shouldReturnTrueWhenCurrentUrlIsObtained() {
        BDDMockito.given((Object)this.mockWebDriver.getCurrentUrl()).willReturn((Object)"foo");
        Assertions.assertThat((boolean)this.check.test(this.device)).isTrue();
    }

    @Test
    public void shouldReturnFalseWhenWebDriverExceptionIsRaised() {
        BDDMockito.given((Object)this.mockWebDriver.getCurrentUrl()).willThrow(new Throwable[]{new WebDriverException()});
        Assertions.assertThat((boolean)this.check.test(this.device)).isFalse();
    }
}

