/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.support;

import io.webdevice.device.Device;
import io.webdevice.device.DeviceNotProvidedException;
import io.webdevice.device.DeviceProvider;
import io.webdevice.device.Devices;
import io.webdevice.support.SimpleDeviceRegistry;
import io.webdevice.test.UnitTest;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.openqa.selenium.WebDriver;

public class SimpleDeviceRegistryTest
extends UnitTest {
    private SimpleDeviceRegistry registry;
    @Mock
    private WebDriver mockWebDriver;
    private Device<WebDriver> device;
    @Mock
    private DeviceProvider<WebDriver> mockProvider;

    @Before
    public void setUp() {
        this.registry = new SimpleDeviceRegistry();
        this.device = Devices.directDevice((String)"iphone", (WebDriver)this.mockWebDriver);
    }

    @Test(expected=DeviceNotProvidedException.class)
    public void provideShouldRaiseDeviceNotProvidedExceptionWhenProviderNotRegistered() {
        this.registry.provide("iphone");
    }

    @Test
    public void provideShouldReturnDeviceFromProvider() {
        this.registry.withProvider("iphone", this.mockProvider);
        BDDMockito.given((Object)((Device)this.mockProvider.get())).willReturn(this.device);
        Assertions.assertThat((Object)this.registry.provide("iphone")).isSameAs(this.device);
    }

    @Test(expected=DeviceNotProvidedException.class)
    public void releaseShouldRaiseDeviceNotProvidedExceptionWhenProviderNotRegistered() {
        this.registry.release(this.device);
    }

    @Test
    public void releaseShouldReturnDeviceToProvider() {
        this.registry.withProvider("iphone", this.mockProvider).release(this.device);
        ((DeviceProvider)Mockito.verify(this.mockProvider)).accept(this.device);
    }
}

