/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.support;

import io.webdevice.support.RelativeNavigation;
import io.webdevice.test.UnitTest;
import java.net.URL;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.openqa.selenium.WebDriver;

public class RelativeNavigationTest
extends UnitTest {
    @Mock
    private WebDriver.Navigation mockNavigation;
    private String root;
    private RelativeNavigation navigation;

    @Before
    public void setUp() {
        this.root = "http://localhost";
        this.navigation = new RelativeNavigation(this.mockNavigation, path -> this.root.concat((String)path));
    }

    @Test
    public void shouldCanonicalizeStringUrls() {
        this.navigation.to("/foo");
        ((WebDriver.Navigation)Mockito.verify((Object)this.mockNavigation)).to("http://localhost/foo");
    }

    @Test
    public void shouldNotCanonicalizeObjectUrls() throws Exception {
        URL url = new URL("http://remotehost");
        this.navigation.to(url);
        ((WebDriver.Navigation)Mockito.verify((Object)this.mockNavigation)).to(url);
    }

    @Test
    public void backShouldDelegate() {
        this.navigation.back();
        ((WebDriver.Navigation)Mockito.verify((Object)this.mockNavigation)).back();
    }

    @Test
    public void forwardShouldDelegate() {
        this.navigation.forward();
        ((WebDriver.Navigation)Mockito.verify((Object)this.mockNavigation)).forward();
    }

    @Test
    public void refreshShouldDelegate() {
        this.navigation.refresh();
        ((WebDriver.Navigation)Mockito.verify((Object)this.mockNavigation)).refresh();
    }
}

