/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.support;

import com.google.common.collect.ImmutableMap;
import io.webdevice.device.Devices;
import io.webdevice.support.ProtectedCapabilities;
import io.webdevice.support.ProtectedWebDriver;
import io.webdevice.test.UnitTest;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.Response;

public class ProtectedWebDriverTest
extends UnitTest {
    private Set<String> confidential;
    private Capabilities desiredCapabilities;
    @Mock
    private CommandExecutor mockCommandExecutor;

    @Before
    public void setUp() {
        this.desiredCapabilities = DesiredCapabilities.iphone();
        this.confidential = new LinkedHashSet<String>();
    }

    @Test
    public void shouldProtectCapabilitiesAfterConstruction() throws Exception {
        BDDMockito.given((Object)this.mockCommandExecutor.execute(this.newSessionCommand())).willReturn((Object)this.iPadOnMacResponse());
        ProtectedWebDriver driver = this.newDriver();
        Assertions.assertThat((Object)driver.getCapabilities()).isInstanceOf(ProtectedCapabilities.class);
    }

    @Test
    public void shouldProtectCapabilitiesAfterConstructionAndDriverUse() throws Exception {
        BDDMockito.given((Object)this.mockCommandExecutor.execute(this.newSessionCommand())).willReturn((Object)this.iPadOnMacResponse());
        ProtectedWebDriver driver = this.newDriver();
        driver.get("foo");
        Assertions.assertThat((Object)driver.getCapabilities()).isInstanceOf(ProtectedCapabilities.class);
    }

    private Command newSessionCommand() {
        return new Command(null, "newSession", (Map)ImmutableMap.of((Object)"desiredCapabilities", (Object)this.desiredCapabilities));
    }

    private Response iPadOnMacResponse() {
        Response response = new Response(Devices.randomSessionId());
        response.setValue((Object)ImmutableMap.of((Object)"browserName", (Object)"iPad", (Object)"platformName", (Object)Platform.MAC.toString()));
        return response;
    }

    private ProtectedWebDriver newDriver() {
        return new ProtectedWebDriver(this.mockCommandExecutor, this.desiredCapabilities, this.confidential);
    }
}

