/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.support;

import io.webdevice.support.ProtectedCapabilities;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;

public class ProtectedCapabilitiesTest {
    private Set<String> confidential;
    private ProtectedCapabilities capabilities;

    @Before
    public void setUp() {
        this.confidential = new LinkedHashSet<String>();
        this.capabilities = new ProtectedCapabilities((Capabilities)new MutableCapabilities(), () -> this.confidential);
    }

    @Test
    public void shouldNotMaskCapability() {
        this.capabilities.setCapability("accessKey", "2secret4u");
        Assertions.assertThat((String)this.capabilities.toString()).isEqualTo("{accessKey: 2secret4u}");
    }

    @Test
    public void shouldMaskConfidentialCapability() {
        this.confidential.add("accessKey");
        this.capabilities.setCapability("accessKey", "2secret4u");
        Assertions.assertThat((String)this.capabilities.toString()).isEqualTo("{accessKey: ********}");
    }

    @Test
    public void shouldNotMaskNestedConfidentialCapability() {
        MutableCapabilities sauceOptions = new MutableCapabilities();
        sauceOptions.setCapability("accessKey", "2secret4u");
        this.capabilities.setCapability("sauce:options", (Object)sauceOptions);
        Assertions.assertThat((String)this.capabilities.toString()).isEqualTo("{sauce:options: {accessKey: 2secret4u}}");
    }

    @Test
    public void shouldMaskNestedConfidentialCapability() {
        this.confidential.add("accessKey");
        MutableCapabilities sauceOptions = new MutableCapabilities();
        sauceOptions.setCapability("accessKey", "2secret4u");
        this.capabilities.setCapability("sauce:options", (Object)sauceOptions);
        Assertions.assertThat((String)this.capabilities.toString()).isEqualTo("{sauce:options: {accessKey: ********}}");
    }

    @Test
    public void maskShouldProtectConfidentialCapabilities() {
        MutableCapabilities capabilities = new MutableCapabilities();
        capabilities.setCapability("accessKey", "2secret4u");
        Assertions.assertThat((String)ProtectedCapabilities.mask((Capabilities)capabilities, Collections.singleton("accessKey"))).isEqualTo("{accessKey: ********}");
    }

    @Test
    public void shouldMimicCapabilitiesToString() {
        this.capabilities.setCapability("array", (Object)new String[]{"one", null});
        this.capabilities.setCapability("list", Collections.singletonList("one"));
        this.capabilities.setCapability("null", (String)null);
        this.capabilities.setCapability("truncated", "1234567890123456789012345678901");
        Assertions.assertThat((String)this.capabilities.toString()).isEqualTo("{array: [one, null], list: [one], truncated: 123456789012345678901234567...}");
    }
}

