/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.device;

import io.github.bonigarcia.wdm.WebDriverManager;
import io.webdevice.device.BadWebDriver;
import io.webdevice.device.Device;
import io.webdevice.device.DirectDeviceProvider;
import io.webdevice.device.WebDriverForTest;
import io.webdevice.test.UnitTest;
import java.util.Collections;
import java.util.function.Function;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.BDDMockito;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.DesiredCapabilities;

public class DirectDeviceProviderTest
extends UnitTest {
    @Mock
    private Appender mockAppender;
    @Captor
    private ArgumentCaptor<LoggingEvent> loggingEventCaptor;
    @Mock
    private Function<Class<WebDriverForTest>, WebDriverManager> mockFactory;
    private DirectDeviceProvider<WebDriverForTest> provider;
    @Mock
    private WebDriverManager mockManager;

    @Before
    public void setUp() {
        Logger.getLogger(DirectDeviceProvider.class).addAppender(this.mockAppender);
        this.provider = new DirectDeviceProvider("iphone", WebDriverForTest.class, this.mockFactory);
    }

    @After
    public void tearDown() {
        Logger.getLogger(DirectDeviceProvider.class).removeAppender(this.mockAppender);
    }

    @Test
    public void initializeShouldSetUpWebDriverManagerForType() {
        BDDMockito.given((Object)this.mockFactory.apply(WebDriverForTest.class)).willReturn((Object)this.mockManager);
        this.provider.initialize();
        ((WebDriverManager)Mockito.verify((Object)this.mockManager)).setup();
        ((Function)Mockito.verify(this.mockFactory)).apply(WebDriverForTest.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockFactory, this.mockManager});
    }

    @Test(expected=WebDriverException.class)
    public void shouldRaiseWebDriverExceptionWhenConstructionFails() {
        new DirectDeviceProvider("iphone", BadWebDriver.class, null).get();
    }

    @Test
    public void getShouldCreateDirectProviderUsingTypeConstructorWithNoArgs() {
        BDDMockito.given((Object)this.mockFactory.apply(WebDriverForTest.class)).willReturn((Object)this.mockManager);
        this.provider.initialize();
        Assertions.assertThat((Object)this.provider.getCapabilities()).isNull();
        Device device = this.provider.get();
        Assertions.assertThat((Object)((WebDriverForTest)device.getDriver())).isInstanceOf(WebDriverForTest.class);
        Assertions.assertThat((String)device.getName()).isEqualTo("iphone");
        Assertions.assertThat((Object)device.getSessionId()).isNotNull();
        Assertions.assertThat((Object)device.getSessionId()).isSameAs((Object)device.getSessionId());
    }

    @Test
    public void getShouldCreateDirectProviderUsingTypeConstructorWithCapabilities() {
        BDDMockito.given((Object)this.mockFactory.apply(WebDriverForTest.class)).willReturn((Object)this.mockManager);
        this.provider.setCapabilities((Capabilities)DesiredCapabilities.iphone());
        this.provider.initialize();
        Device device = this.provider.get();
        Assertions.assertThat((Object)((WebDriverForTest)device.getDriver())).isInstanceOf(WebDriverForTest.class);
        Assertions.assertThat((String)device.getName()).isEqualTo("iphone");
        Assertions.assertThat((Object)device.getSessionId()).isNotNull();
        Assertions.assertThat((Object)device.getSessionId()).isSameAs((Object)device.getSessionId());
        Assertions.assertThat((Object)((HasCapabilities)device.as(HasCapabilities.class)).getCapabilities()).isSameAs((Object)this.provider.getCapabilities());
    }

    @Test
    public void getShouldProtectCapabilitiesWhenLogging() {
        BDDMockito.given((Object)this.mockFactory.apply(WebDriverForTest.class)).willReturn((Object)this.mockManager);
        MutableCapabilities capabilities = new MutableCapabilities();
        capabilities.setCapability("accessKey", "2secret4u");
        this.provider.setCapabilities((Capabilities)capabilities);
        this.provider.setConfidential(Collections.singleton("accessKey"));
        this.provider.initialize();
        this.provider.get();
        ((Appender)Mockito.verify((Object)this.mockAppender, (VerificationMode)Mockito.times((int)3))).doAppend((LoggingEvent)this.loggingEventCaptor.capture());
        Assertions.assertThat((Object)((LoggingEvent)this.loggingEventCaptor.getValue()).getMessage()).isEqualTo((Object)"Instantiating class io.webdevice.device.WebDriverForTest with capabilities {accessKey: ********}");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getConfidentialShouldReturnImmutableSet() {
        this.provider.getConfidential().add("foo");
    }
}

