/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.device;

import io.webdevice.device.Device;
import io.webdevice.device.Devices;
import io.webdevice.test.UnitTest;
import java.util.Objects;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.interactions.Interactive;
import org.openqa.selenium.remote.SessionId;

public class DeviceTest
extends UnitTest {
    @Mock(extraInterfaces={JavascriptExecutor.class, HasCapabilities.class, Interactive.class, TakesScreenshot.class})
    private WebDriver mockWebDriver;
    @Mock
    private Function<WebDriver, SessionId> mockSessionFunction;
    private Device<WebDriver> device;
    private SessionId sessionId;

    @Before
    public void setUp() {
        this.device = new Device("iphone", this.mockWebDriver, this.mockSessionFunction);
        this.sessionId = Devices.randomSessionId();
    }

    @Test
    public void shouldReturnName() {
        Assertions.assertThat((String)this.device.getName()).isEqualTo("iphone");
    }

    @Test
    public void shouldReturnDriver() {
        Assertions.assertThat((Object)this.device.getDriver()).isSameAs((Object)this.mockWebDriver);
    }

    @Test
    public void asShouldCastToImplementedInterface() {
        JavascriptExecutor executor = (JavascriptExecutor)this.device.as(JavascriptExecutor.class);
        Assertions.assertThat((Object)executor).isSameAs((Object)this.mockWebDriver);
    }

    @Test
    public void shouldUseFunctionToComputeSessionId() {
        BDDMockito.given((Object)this.mockSessionFunction.apply(this.mockWebDriver)).willReturn((Object)this.sessionId);
        Assertions.assertThat((Object)this.device.getSessionId()).isSameAs((Object)this.sessionId);
    }

    @Test
    public void shouldPerformActionWithDriver() {
        this.device.perform(driver -> {
            Assertions.assertThat((Object)driver).isSameAs((Object)this.mockWebDriver);
            driver.quit();
        });
        ((WebDriver)Mockito.verify((Object)this.mockWebDriver)).quit();
    }

    @Test
    public void shouldInvokeFunctionWithDriver() {
        SessionId actual = (SessionId)this.device.invoke(driver -> {
            Assertions.assertThat((Object)driver).isSameAs((Object)this.mockWebDriver);
            return this.sessionId;
        });
        Assertions.assertThat((Object)actual).isSameAs((Object)this.sessionId);
    }

    @Test
    public void equalityShouldBeBasedOnNameDriverTypeAndSessionId() {
        BDDMockito.given((Object)this.mockSessionFunction.apply(this.mockWebDriver)).willReturn((Object)this.sessionId);
        Function mockSessionFunction2 = (Function)Mockito.mock(Function.class);
        BDDMockito.given((Object)((SessionId)mockSessionFunction2.apply(this.mockWebDriver))).willReturn((Object)Devices.randomSessionId());
        Assertions.assertThat((boolean)this.device.equals((Object)new Device("iphone", this.mockWebDriver, this.mockSessionFunction))).isTrue();
        Assertions.assertThat((boolean)this.device.equals((Object)new Device("ipad", this.mockWebDriver, this.mockSessionFunction))).isFalse();
        BDDMockito.given((Object)((SessionId)mockSessionFunction2.apply(this.mockWebDriver))).willReturn((Object)Devices.randomSessionId());
        Assertions.assertThat((boolean)this.device.equals((Object)new Device("iphone", this.mockWebDriver, mockSessionFunction2))).isFalse();
    }

    @Test
    public void hashCodeShouldBeBasedOnNameDriverTypeAndSessionId() {
        BDDMockito.given((Object)this.mockSessionFunction.apply(this.mockWebDriver)).willReturn((Object)this.sessionId);
        Assertions.assertThat((int)this.device.hashCode()).isEqualTo(Objects.hash("iphone", this.mockWebDriver.getClass(), this.sessionId));
    }
}

