/*
 * Decompiled with CFR 0.152.
 */
package io.webdevice.device;

import io.webdevice.device.Device;
import io.webdevice.device.DevicePool;
import io.webdevice.device.DeviceProvider;
import io.webdevice.device.Devices;
import io.webdevice.test.UnitTest;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.SessionId;

public class DevicePoolTest
extends UnitTest {
    @Mock
    private Device<WebDriver> mockDevice;
    @Mock
    private Device<WebDriver> mockDevice2;
    @Mock
    private DeviceProvider<WebDriver> mockProvider;
    @Mock
    private Function<Device<WebDriver>, Boolean> mockTestFunction;
    private BlockingDeque<Device<WebDriver>> free;
    private BlockingDeque<Device<WebDriver>> used;
    private DevicePool<WebDriver> pool;
    private SessionId sessionId;

    @Before
    public void setUp() {
        this.free = new LinkedBlockingDeque<Device<WebDriver>>();
        this.used = new LinkedBlockingDeque<Device<WebDriver>>();
        this.pool = new DevicePool("device", this.mockProvider, this.mockTestFunction, this.free, this.used);
        this.sessionId = Devices.randomSessionId();
    }

    @Test
    public void getShouldCreateAndPoolDeviceWhenNoneAreFree() {
        Assertions.assertThat((boolean)this.free.isEmpty()).isTrue();
        BDDMockito.given((Object)this.mockDevice.getSessionId()).willReturn((Object)this.sessionId);
        BDDMockito.given((Object)((Device)this.mockProvider.get())).willReturn(this.mockDevice);
        Device actual = this.pool.get();
        Assertions.assertThat((Object)actual).isSameAs(this.mockDevice);
        Assertions.assertThat(this.free).isEmpty();
        Assertions.assertThat(this.used).contains((Object[])new Device[]{actual});
        ((Device)Mockito.verify(this.mockDevice, (VerificationMode)Mockito.atLeastOnce())).getSessionId();
        ((DeviceProvider)Mockito.verify(this.mockProvider)).get();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockDevice, this.mockProvider});
    }

    @Test
    public void getShouldProvidePooledDeviceWhenUsableDeviceIsAcquiredFromFree() {
        this.free.add(this.mockDevice);
        BDDMockito.given((Object)this.mockTestFunction.apply(this.mockDevice)).willReturn((Object)true);
        BDDMockito.given((Object)this.mockDevice.getSessionId()).willReturn((Object)this.sessionId);
        Device actual = this.pool.get();
        Assertions.assertThat((Object)actual).isSameAs(this.mockDevice);
        Assertions.assertThat(this.free).isEmpty();
        Assertions.assertThat(this.used).contains((Object[])new Device[]{actual});
        ((Function)Mockito.verify(this.mockTestFunction, (VerificationMode)Mockito.atLeastOnce())).apply(this.mockDevice);
        ((Device)Mockito.verify(this.mockDevice, (VerificationMode)Mockito.atLeastOnce())).getSessionId();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockDevice, this.mockProvider});
    }

    @Test
    public void getShouldReleaseDeviceToProviderAndCreateNewOneWhenUnusableDeviceIsAcquiredFromFree() {
        this.free.add(this.mockDevice);
        BDDMockito.given((Object)this.mockTestFunction.apply(this.mockDevice)).willReturn((Object)false);
        BDDMockito.given((Object)this.mockDevice.getSessionId()).willReturn((Object)this.sessionId);
        BDDMockito.given((Object)this.mockDevice2.getSessionId()).willReturn((Object)Devices.randomSessionId());
        BDDMockito.given((Object)((Device)this.mockProvider.get())).willReturn(this.mockDevice2);
        Device actual = this.pool.get();
        Assertions.assertThat((Object)actual).isSameAs(this.mockDevice2);
        Assertions.assertThat(this.free).isEmpty();
        Assertions.assertThat(this.used).contains((Object[])new Device[]{actual});
        ((Function)Mockito.verify(this.mockTestFunction, (VerificationMode)Mockito.atLeastOnce())).apply(this.mockDevice);
        ((Device)Mockito.verify(this.mockDevice, (VerificationMode)Mockito.atLeastOnce())).getSessionId();
        ((Device)Mockito.verify(this.mockDevice2, (VerificationMode)Mockito.atLeastOnce())).getSessionId();
        ((DeviceProvider)Mockito.verify(this.mockProvider)).accept(this.mockDevice);
        ((DeviceProvider)Mockito.verify(this.mockProvider)).get();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockDevice, this.mockDevice2, this.mockProvider});
    }

    @Test
    public void getShouldReleaseDeviceToProviderConsumingExceptionAndCreateNewOneWhenUnusableDeviceIsAcquiredFromFree() {
        this.free.add(this.mockDevice);
        BDDMockito.given((Object)this.mockTestFunction.apply(this.mockDevice)).willReturn((Object)false);
        BDDMockito.given((Object)this.mockDevice.getSessionId()).willReturn((Object)this.sessionId);
        ((DeviceProvider)BDDMockito.willThrow((Throwable[])new Throwable[]{new RuntimeException("boom1")}).given(this.mockProvider)).accept(this.mockDevice);
        BDDMockito.given((Object)this.mockDevice2.getSessionId()).willReturn((Object)Devices.randomSessionId());
        BDDMockito.given((Object)((Device)this.mockProvider.get())).willReturn(this.mockDevice2);
        Device actual = this.pool.get();
        Assertions.assertThat((Object)actual).isSameAs(this.mockDevice2);
        Assertions.assertThat(this.free).isEmpty();
        Assertions.assertThat(this.used).contains((Object[])new Device[]{actual});
        ((Function)Mockito.verify(this.mockTestFunction, (VerificationMode)Mockito.atLeastOnce())).apply(this.mockDevice);
        ((Device)Mockito.verify(this.mockDevice, (VerificationMode)Mockito.atLeastOnce())).getSessionId();
        ((Device)Mockito.verify(this.mockDevice2, (VerificationMode)Mockito.atLeastOnce())).getSessionId();
        ((DeviceProvider)Mockito.verify(this.mockProvider)).accept(this.mockDevice);
        ((DeviceProvider)Mockito.verify(this.mockProvider)).get();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockDevice, this.mockDevice2, this.mockProvider});
    }

    @Test
    public void acceptShouldOnlyTakeDeviceIfItWasUsed() {
        this.used.add(this.mockDevice);
        Assertions.assertThat((boolean)this.used.isEmpty()).isFalse();
        Assertions.assertThat((boolean)this.free.isEmpty()).isTrue();
        this.pool.accept(this.mockDevice);
        Assertions.assertThat((boolean)this.used.isEmpty()).isTrue();
        Assertions.assertThat((boolean)this.free.isEmpty()).isFalse();
        ((Device)Mockito.verify(this.mockDevice, (VerificationMode)Mockito.atLeastOnce())).getSessionId();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockDevice, this.mockDevice2, this.mockProvider});
    }

    @Test
    public void acceptShouldIgnoreDeviceIfItWasNotUsed() {
        Assertions.assertThat((boolean)this.used.isEmpty()).isTrue();
        Assertions.assertThat((boolean)this.free.isEmpty()).isTrue();
        this.pool.accept(this.mockDevice);
        Assertions.assertThat((boolean)this.used.isEmpty()).isTrue();
        Assertions.assertThat((boolean)this.free.isEmpty()).isTrue();
        ((Device)Mockito.verify(this.mockDevice, (VerificationMode)Mockito.atLeastOnce())).getSessionId();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockDevice, this.mockDevice2, this.mockProvider});
    }

    @Test
    public void disposeShouldReleaseAllDevicesToProvider() {
        this.used.add(this.mockDevice2);
        this.free.add(this.mockDevice);
        Assertions.assertThat((boolean)this.used.isEmpty()).isFalse();
        Assertions.assertThat((boolean)this.free.isEmpty()).isFalse();
        this.pool.dispose();
        Assertions.assertThat((boolean)this.used.isEmpty()).isTrue();
        Assertions.assertThat((boolean)this.free.isEmpty()).isTrue();
        ((Device)Mockito.verify(this.mockDevice, (VerificationMode)Mockito.atLeastOnce())).getSessionId();
        ((DeviceProvider)Mockito.verify(this.mockProvider)).accept(this.mockDevice);
        ((Device)Mockito.verify(this.mockDevice2, (VerificationMode)Mockito.atLeastOnce())).getSessionId();
        ((DeviceProvider)Mockito.verify(this.mockProvider)).accept(this.mockDevice2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockDevice, this.mockDevice2, this.mockProvider});
    }

    @Test
    public void disposeShouldReleaseAllDevicesToProviderConsumingAllExceptions() {
        this.used.add(this.mockDevice2);
        this.free.add(this.mockDevice);
        Assertions.assertThat((boolean)this.used.isEmpty()).isFalse();
        Assertions.assertThat((boolean)this.free.isEmpty()).isFalse();
        ((DeviceProvider)BDDMockito.willThrow((Throwable[])new Throwable[]{new RuntimeException("boom1")}).given(this.mockProvider)).accept(this.mockDevice);
        ((DeviceProvider)BDDMockito.willThrow((Throwable[])new Throwable[]{new RuntimeException("boom2")}).given(this.mockProvider)).accept(this.mockDevice2);
        this.pool.dispose();
        Assertions.assertThat((boolean)this.used.isEmpty()).isTrue();
        Assertions.assertThat((boolean)this.free.isEmpty()).isTrue();
        ((Device)Mockito.verify(this.mockDevice, (VerificationMode)Mockito.atLeastOnce())).getSessionId();
        ((DeviceProvider)Mockito.verify(this.mockProvider)).accept(this.mockDevice);
        ((Device)Mockito.verify(this.mockDevice2, (VerificationMode)Mockito.atLeastOnce())).getSessionId();
        ((DeviceProvider)Mockito.verify(this.mockProvider)).accept(this.mockDevice2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockDevice, this.mockDevice2, this.mockProvider});
    }
}

