/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.siteapi.integrationtestsupport.httpclient;

import io.wcm.siteapi.integrationtestsupport.IntegrationTestContextBuilder;
import io.wcm.siteapi.integrationtestsupport.httpclient.HttpRequestFailedException;
import io.wcm.siteapi.integrationtestsupport.httpclient.HttpResponse;
import io.wcm.siteapi.integrationtestsupport.httpclient.StringHttpResponse;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class HttpClient {
    private final java.net.http.HttpClient delegateHttpClient;
    private final Duration requestTimeout;

    public HttpClient(IntegrationTestContextBuilder builder) {
        this.delegateHttpClient = java.net.http.HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(builder.getHttpConnectTimeout()).build();
        this.requestTimeout = builder.getHttpRequestTimeout();
    }

    @NotNull
    public HttpResponse<String> get(@NotNull String url) {
        String urlWithTimestamp = this.appendTimestamp(url);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(urlWithTimestamp)).timeout(this.requestTimeout).build();
        try {
            return new StringHttpResponse(this.delegateHttpClient.send(request, HttpResponse.BodyHandlers.ofString()));
        }
        catch (IOException ex) {
            throw new HttpRequestFailedException("Unable to fetch " + urlWithTimestamp + ": " + ex.getMessage(), ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ex);
        }
    }

    @NotNull
    public String getBody(@NotNull String url) {
        String urlWithTimestamp = this.appendTimestamp(url);
        HttpResponse<String> response = this.get(urlWithTimestamp);
        if (response.statusCode() == 200) {
            return response.body();
        }
        throw new HttpRequestFailedException(urlWithTimestamp + " returned HTTP " + response.statusCode());
    }

    private String appendTimestamp(String url) {
        if (!StringUtils.contains((CharSequence)url, (CharSequence)"?timestamp=")) {
            return url + "?timestamp=" + System.currentTimeMillis();
        }
        return url;
    }
}

