/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.siteapi.integrationtestsupport.crawler;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import io.wcm.siteapi.integrationtestsupport.IntegrationTestContext;
import io.wcm.siteapi.integrationtestsupport.crawler.Crawler;
import io.wcm.siteapi.integrationtestsupport.httpclient.HttpRequestFailedException;
import io.wcm.siteapi.openapi.validator.ContentValidationException;
import io.wcm.siteapi.openapi.validator.OpenApiSchemaValidator;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

class CrawlerItem {
    private final Crawler crawler;
    private final IntegrationTestContext context;
    private final String url;
    private final String refererUrl;

    CrawlerItem(Crawler crawler, IntegrationTestContext context, String url) {
        this(crawler, context, url, null);
    }

    CrawlerItem(Crawler crawler, IntegrationTestContext context, String url, String refererUrl) {
        this.crawler = crawler;
        this.context = context;
        this.url = url;
        this.refererUrl = refererUrl;
    }

    void fetch() {
        String json;
        String suffix;
        if (!this.crawler.visitUrl(this.url)) {
            return;
        }
        try {
            suffix = this.crawler.parseSuffix(this.url);
        }
        catch (IllegalArgumentException ex) {
            this.crawler.logFailedVisitUrl(this.url, this.appendReferer(ex.getMessage()), "");
            return;
        }
        OpenApiSchemaValidator validator = this.context.getValidator(suffix);
        try {
            json = this.context.getHttpClient().getBody(this.url);
        }
        catch (HttpRequestFailedException ex) {
            this.crawler.logFailedVisitUrl(this.url, this.appendReferer(ex.getMessage()), "");
            return;
        }
        try {
            validator.validate(json);
        }
        catch (ContentValidationException ex) {
            this.crawler.logFailedVisitUrl(this.url, "Validator(" + this.context.getApiVersion() + "," + suffix + ") " + ex.getMessage(), json);
            return;
        }
        this.getAllLinks(JsonPath.parse((String)json), suffix).forEach(followUrl -> new CrawlerItem(this.crawler, this.context, (String)followUrl, this.url).fetch());
    }

    private Stream<String> getAllLinks(@NotNull DocumentContext jsonPathContext, @NotNull String suffix) {
        return this.crawler.getLinkExtractors().stream().filter(extractor -> extractor.accept(suffix)).flatMap(extractor -> extractor.getLinks(jsonPathContext)).distinct();
    }

    private String appendReferer(String message) {
        if (this.refererUrl != null) {
            return message + ", refererer: " + this.refererUrl;
        }
        return message;
    }
}

