/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.siteapi.integrationtestsupport.crawler;

import io.wcm.siteapi.integrationtestsupport.IntegrationTestContext;
import io.wcm.siteapi.integrationtestsupport.crawler.CrawlerItem;
import io.wcm.siteapi.integrationtestsupport.crawler.UrlParser;
import io.wcm.siteapi.integrationtestsupport.linkextractor.LinkExtractor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Crawler {
    private final IntegrationTestContext context;
    private final Collection<LinkExtractor> linkExtractors;
    private final Set<String> visitedUrls = new HashSet<String>();
    private final Set<String> failedUrls = new LinkedHashSet<String>();
    private final UrlParser urlParser;
    private static final Logger log = LoggerFactory.getLogger((String)Crawler.class.getSimpleName());

    public Crawler(@NotNull IntegrationTestContext context, @NotNull List<LinkExtractor> linkExtractors) {
        this.context = context;
        this.linkExtractors = Collections.unmodifiableCollection(linkExtractors);
        this.urlParser = new UrlParser(context.getPublishUrl(), context.getSelector(), context.getApiVersion(), context.getExtension());
    }

    public void start(@NotNull String url) {
        CrawlerItem item = new CrawlerItem(this, this.context, url);
        item.fetch();
    }

    public int numberOfVisits() {
        return this.visitedUrls.size();
    }

    public int numberOfFailedVisits() {
        return this.failedUrls.size();
    }

    @NotNull
    public Collection<String> failedVisitUrls() {
        return Collections.unmodifiableCollection(this.failedUrls);
    }

    boolean visitUrl(@NotNull String url) {
        boolean doVisit = this.visitedUrls.add(url);
        if (doVisit) {
            log.info("Visit: {}", (Object)url);
        } else {
            log.debug("Skip: {}", (Object)url);
        }
        return doVisit;
    }

    void logFailedVisitUrl(@NotNull String url, @NotNull String message, @NotNull String fullResponse) {
        log.error("Validation FAILED: {}\n{}\n\n{}\n", new Object[]{url, message, fullResponse});
        this.failedUrls.add(url);
    }

    @NotNull
    Collection<LinkExtractor> getLinkExtractors() {
        return this.linkExtractors;
    }

    @NotNull
    String parseSuffix(@NotNull String url) {
        return this.urlParser.parseSuffix(url);
    }
}

