/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.validation.impl;

import io.vertx.ext.web.api.validation.impl.XMLTypeValidator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXParseException;

public class XMLTypeValidatorTest {
    @Test
    public void isValidPattern() throws IOException {
        block15: {
            File tempFile = File.createTempFile("xml-", "-xxe");
            tempFile.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(tempFile);){
                ((OutputStream)out).write("<appinfo>you should not see me!!!</appinfo>".getBytes(StandardCharsets.UTF_8));
            }
            try {
                XMLTypeValidator.XMLTypeValidatorFactory.createXMLTypeValidator((String)("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<!DOCTYPE foo [ <!ELEMENT foo ANY >\n<!ENTITY xxe SYSTEM \"file://" + tempFile.getCanonicalPath() + "\" >]>\n<creds>\n    <user>&xxe;</user>\n    <pass>mypass</pass>\n</creds>"));
            }
            catch (Throwable e) {
                if (!(e.getCause() instanceof SAXParseException)) break block15;
                SAXParseException xxe = (SAXParseException)e.getCause();
                String message = xxe.getMessage();
                if (xxe.getSystemId() == null && message.contains(tempFile.getName()) && message.contains("accessExternalDTD")) break block15;
                Assert.fail((String)("XML got access to FS: " + message));
            }
        }
    }
}

