/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.validation.impl;

import io.vertx.ext.web.api.RequestParameter;
import io.vertx.ext.web.api.validation.ParameterTypeValidator;
import io.vertx.ext.web.api.validation.ValidationException;
import io.vertx.ext.web.api.validation.impl.EnumTypeValidator;
import io.vertx.ext.web.api.validation.impl.NumericTypeValidator;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class EnumTypeValidatorTest {
    @Test
    public void isValid() {
        List<String> strings = Arrays.asList("hello", "world", "im", "francesco", "and", "i", "dont", "like", "testing");
        EnumTypeValidator enumTypeValidator = new EnumTypeValidator(strings, null);
        strings.forEach(s -> Assert.assertEquals((Object)RequestParameter.create((Object)s), (Object)enumTypeValidator.isValid(s)));
    }

    @Test
    public void isValidEnumIntegers() {
        List<String> strings = Arrays.asList("1", "2", "3", "4", "5");
        EnumTypeValidator enumTypeValidator = new EnumTypeValidator(strings.stream().map(Integer::valueOf).collect(Collectors.toList()), (ParameterTypeValidator)new NumericTypeValidator(Integer.class));
        strings.forEach(s -> Assert.assertEquals((Object)RequestParameter.create((Object)Integer.valueOf(s)), (Object)enumTypeValidator.isValid(s)));
    }

    @Test(expected=ValidationException.class)
    public void isNotValid() {
        EnumTypeValidator enumTypeValidator = new EnumTypeValidator(Arrays.asList("hello", "world"), null);
        enumTypeValidator.isValid("francesco");
    }
}

