/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.api.RequestParameter;
import io.vertx.ext.web.api.impl.RequestParameterImpl;
import io.vertx.ext.web.api.impl.RequestParametersImpl;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class RequestParametersTest {
    @Test
    public void testRequestParameterToJsonNumber() {
        RequestParameterImpl param = new RequestParameterImpl("bla", (Object)1);
        Assert.assertEquals((Object)1, (Object)param.toJson());
    }

    @Test
    public void testRequestParameterToJsonString() {
        RequestParameterImpl param = new RequestParameterImpl("bla", (Object)"string");
        Assert.assertEquals((Object)"string", (Object)param.toJson());
    }

    @Test
    public void testRequestParameterToJsonMap() {
        RequestParameterImpl param1 = new RequestParameterImpl("param1", (Object)1);
        RequestParameterImpl param2 = new RequestParameterImpl("param2", (Object)"string");
        RequestParameterImpl param3 = new RequestParameterImpl("param3", null);
        HashMap<String, RequestParameterImpl> paramsMap = new HashMap<String, RequestParameterImpl>();
        paramsMap.put(param1.getName(), param1);
        paramsMap.put(param2.getName(), param2);
        paramsMap.put(param3.getName(), param3);
        RequestParameterImpl params = new RequestParameterImpl("params", paramsMap);
        Object result = params.toJson();
        Assert.assertTrue((boolean)(result instanceof JsonObject));
        JsonObject object = (JsonObject)result;
        Assert.assertEquals((Object)1, (Object)object.getValue("param1"));
        Assert.assertEquals((Object)"string", (Object)object.getValue("param2"));
        Assert.assertNull((Object)object.getValue("param3"));
    }

    @Test
    public void testRequestParameterToJsonArray() {
        RequestParameterImpl param1 = new RequestParameterImpl("param1", (Object)1);
        RequestParameterImpl param2 = new RequestParameterImpl("param2", (Object)"string");
        RequestParameterImpl param3 = new RequestParameterImpl("param3", null);
        ArrayList<RequestParameterImpl> paramsList = new ArrayList<RequestParameterImpl>();
        paramsList.add(param1);
        paramsList.add(param2);
        paramsList.add(param3);
        RequestParameterImpl params = new RequestParameterImpl("params", paramsList);
        Object result = params.toJson();
        Assert.assertTrue((boolean)(result instanceof JsonArray));
        JsonArray object = (JsonArray)result;
        Assert.assertEquals((Object)1, (Object)object.getValue(0));
        Assert.assertEquals((Object)"string", (Object)object.getValue(1));
        Assert.assertNull((Object)object.getValue(2));
    }

    @Test
    public void testToJsonObjectEmpty() {
        RequestParametersImpl params = new RequestParametersImpl();
        JsonObject obj = params.toJson();
        Assert.assertEquals((long)0L, (long)obj.getJsonObject("path").size());
        Assert.assertEquals((long)0L, (long)obj.getJsonObject("cookie").size());
        Assert.assertEquals((long)0L, (long)obj.getJsonObject("query").size());
        Assert.assertEquals((long)0L, (long)obj.getJsonObject("form").size());
        Assert.assertEquals((long)0L, (long)obj.getJsonObject("header").size());
        Assert.assertNull((Object)obj.getValue("body"));
    }

    @Test
    public void testToJsonObject() {
        RequestParameterImpl param1 = new RequestParameterImpl("param1", (Object)1);
        RequestParameterImpl param2 = new RequestParameterImpl("param2", (Object)"string");
        RequestParameterImpl param3 = new RequestParameterImpl("param3", null);
        HashMap<String, RequestParameterImpl> paramsMap = new HashMap<String, RequestParameterImpl>();
        paramsMap.put(param1.getName(), param1);
        paramsMap.put(param2.getName(), param2);
        paramsMap.put(param3.getName(), param3);
        RequestParameterImpl bodyParam = new RequestParameterImpl("params", paramsMap);
        RequestParametersImpl params = new RequestParametersImpl();
        params.setCookieParameters(paramsMap);
        params.setFormParameters(paramsMap);
        params.setHeaderParameters(paramsMap);
        params.setPathParameters(paramsMap);
        params.setQueryParameters(paramsMap);
        params.setBody((RequestParameter)bodyParam);
        JsonObject obj = params.toJson();
        Assert.assertEquals((long)3L, (long)obj.getJsonObject("path").size());
        Assert.assertEquals((long)3L, (long)obj.getJsonObject("cookie").size());
        Assert.assertEquals((long)3L, (long)obj.getJsonObject("query").size());
        Assert.assertEquals((long)3L, (long)obj.getJsonObject("form").size());
        Assert.assertEquals((long)3L, (long)obj.getJsonObject("header").size());
        Assert.assertEquals((Object)bodyParam.toJson(), (Object)obj.getValue("body"));
    }
}

