/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.validation.impl;

import io.vertx.ext.web.api.validation.ValidationException;
import io.vertx.ext.web.api.validation.impl.NumericTypeValidator;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class NumericTypeValidatorTest {
    @Test
    public void constructorInteger() {
        new NumericTypeValidator(Integer.class, (Object)1);
        NumericTypeValidator v = new NumericTypeValidator(Integer.class, (Object)"1");
        Assert.assertEquals((Object)1, (Object)v.getDefault());
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructorIntegerFailure() {
        new NumericTypeValidator(Integer.class, (Object)2.4);
    }

    @Test
    public void constructorLong() {
        new NumericTypeValidator(Long.class, (Object)1L);
        NumericTypeValidator v = new NumericTypeValidator(Long.class, (Object)"1");
        Assert.assertEquals((Object)1L, (Object)v.getDefault());
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructorLongFailure() {
        new NumericTypeValidator(Long.class, (Object)Float.valueOf(1.0f));
    }

    @Test
    public void constructorDouble() {
        new NumericTypeValidator(Double.class, (Object)1.0);
        NumericTypeValidator v = new NumericTypeValidator(Double.class, (Object)"1");
        Assert.assertEquals((Object)1.0, (Object)v.getDefault());
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructorDoubleFailure() {
        new NumericTypeValidator(Double.class, (Object)Float.valueOf(1.0f));
    }

    @Test
    public void constructorFloat() {
        new NumericTypeValidator(Float.class, (Object)Float.valueOf(1.0f));
        NumericTypeValidator v = new NumericTypeValidator(Float.class, (Object)"1");
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)v.getDefault());
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructorFloatFailure() {
        new NumericTypeValidator(Float.class, (Object)1.0);
    }

    @Test
    public void isValid() {
        NumericTypeValidator v = new NumericTypeValidator(Integer.class);
        v.isValid("1");
    }

    @Test
    public void isValidDefault() {
        Integer i = 1;
        NumericTypeValidator v = new NumericTypeValidator(Integer.class, (Object)i);
        Assert.assertEquals((Object)i, (Object)v.isValid(null).getInteger());
    }

    @Test
    public void isValidMaximum() {
        NumericTypeValidator v = new NumericTypeValidator(Integer.class, Boolean.valueOf(false), Double.valueOf(10.0), null, null, null, null);
        v.isValid("10");
        v.isValid("9");
    }

    @Test
    public void isValidExclusiveMaximum() {
        NumericTypeValidator v = new NumericTypeValidator(Integer.class, Boolean.valueOf(true), Double.valueOf(10.0), null, null, null, null);
        v.isValid("9");
    }

    @Test(expected=ValidationException.class)
    public void isValidMaximumFailure() {
        NumericTypeValidator v = new NumericTypeValidator(Integer.class, Boolean.valueOf(false), Double.valueOf(10.0), null, null, null, null);
        v.isValid("11");
    }

    @Test(expected=ValidationException.class)
    public void isValidExclusiveMaximumFailure() {
        NumericTypeValidator v = new NumericTypeValidator(Integer.class, Boolean.valueOf(true), Double.valueOf(10.0), null, null, null, null);
        v.isValid("10");
    }

    @Test
    public void isValidMinimum() {
        NumericTypeValidator v = new NumericTypeValidator(Integer.class, null, null, Boolean.valueOf(false), Double.valueOf(-10.0), null, null);
        v.isValid("-10");
        v.isValid("-9");
    }

    @Test
    public void isValidExclusiveMinimum() {
        NumericTypeValidator v = new NumericTypeValidator(Integer.class, null, null, Boolean.valueOf(true), Double.valueOf(-10.0), null, null);
        v.isValid("-9");
    }

    @Test(expected=ValidationException.class)
    public void isValidMinimumFailure() {
        NumericTypeValidator v = new NumericTypeValidator(Integer.class, null, null, Boolean.valueOf(false), Double.valueOf(-10.0), null, null);
        v.isValid("-11");
    }

    @Test(expected=ValidationException.class)
    public void isValidExclusiveMinimumFailure() {
        NumericTypeValidator v = new NumericTypeValidator(Integer.class, null, null, Boolean.valueOf(true), Double.valueOf(-10.0), null, null);
        v.isValid("-10");
    }

    @Test
    public void isValidMultipleOf() {
        NumericTypeValidator v = new NumericTypeValidator(Integer.class, null, null, null, null, Double.valueOf(2.0), null);
        v.isValid("4");
    }

    @Test(expected=ValidationException.class)
    public void isValidMultipleOfFailure() {
        NumericTypeValidator v = new NumericTypeValidator(Integer.class, null, null, null, null, Double.valueOf(2.0), null);
        v.isValid("3");
    }

    @Test(expected=ValidationException.class)
    public void isValidEmptyStringFailure() {
        NumericTypeValidator validator = new NumericTypeValidator(Integer.class);
        validator.isValid("");
    }

    @Test(expected=ValidationException.class)
    public void isValidNullStringFailure() {
        NumericTypeValidator validator = new NumericTypeValidator(Integer.class);
        validator.isValid("");
    }

    @Test
    public void isValidCollection() {
        NumericTypeValidator validator = new NumericTypeValidator(Integer.class);
        validator.isValidCollection(Arrays.asList("1"));
    }

    @Test(expected=ValidationException.class)
    public void isValidCollectionFailure() {
        NumericTypeValidator validator = new NumericTypeValidator(Integer.class);
        validator.isValidCollection(Arrays.asList("1", "2", "3"));
    }
}

