/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.contract.openapi3;

import io.netty.handler.codec.http.QueryStringEncoder;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.ResolverCache;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.api.ApiWebTestBase;
import io.vertx.ext.web.api.RequestParameter;
import io.vertx.ext.web.api.RequestParameters;
import io.vertx.ext.web.api.contract.openapi3.impl.OpenAPI3RequestValidationHandlerImpl;
import io.vertx.ext.web.api.contract.openapi3.impl.OpenApi3Utils;
import io.vertx.ext.web.api.validation.ParameterType;
import io.vertx.ext.web.api.validation.ValidationException;
import io.vertx.ext.web.api.validation.ValidationHandler;
import io.vertx.ext.web.api.validation.WebTestValidationBase;
import io.vertx.ext.web.multipart.MultipartForm;
import java.util.ArrayList;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExternalResource;

public class OpenAPI3ValidationTest
extends WebTestValidationBase {
    OpenAPI testSpec;
    ResolverCache refsCache;
    @Rule
    public ExternalResource resource = new ExternalResource(){

        protected void before() throws Throwable {
            OpenAPI3ValidationTest.this.testSpec = OpenAPI3ValidationTest.this.loadSwagger("src/test/resources/swaggers/validation_test.yaml");
            OpenAPI3ValidationTest.this.refsCache = new ResolverCache(OpenAPI3ValidationTest.this.testSpec, null, "src/test/resources/swaggers/validation_test.yaml");
        }

        protected void after() {
        }
    };

    private OpenAPI loadSwagger(String filename) {
        return new OpenAPIV3Parser().readLocation(filename, null, OpenApi3Utils.getParseOptions()).getOpenAPI();
    }

    @Test
    public void testLoadSampleOperationObject() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/pets")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.router.get("/pets").handler((Handler)validationHandler);
        this.router.get("/pets").handler(routingContext -> routingContext.response().setStatusMessage("ok").end()).failureHandler(this.generateFailureHandler(false));
        this.testRequest(HttpMethod.GET, "/pets", 200, "ok");
    }

    @Test
    public void testPathParameter() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/pets/{petId}")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/pets/:petId", HttpMethod.GET, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.pathParameter("petId").getInteger().toString()).end();
        }));
        this.testRequest(HttpMethod.GET, "/pets/3", 200, "3");
    }

    @Test
    public void testPathParameterFailure() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/pets/{petId}")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/pets/:petId", HttpMethod.GET, true, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> routingContext.response().setStatusMessage("ok").end()));
        this.testRequest(HttpMethod.GET, "/pets/three", 400, this.errorMessage(ValidationException.ErrorType.NO_MATCH));
    }

    @Test
    public void testQueryParameterNotRequired() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/pets")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/pets", HttpMethod.GET, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> routingContext.response().setStatusMessage("ok").end()));
        this.testRequest(HttpMethod.GET, "/pets", 200, "ok");
    }

    @Test
    public void testQueryParameterArrayExploded() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/queryTests/arrayTests/formExploded")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/queryTests/arrayTests/formExploded", HttpMethod.GET, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            ArrayList<String> result = new ArrayList<String>();
            for (RequestParameter r : params.queryParameter("parameter").getArray()) {
                result.add(r.getInteger().toString());
            }
            routingContext.response().setStatusMessage(this.serializeInCSVStringArray(result)).end();
        }));
        ArrayList<String> values = new ArrayList<String>();
        values.add("4");
        values.add("2");
        values.add("26");
        StringBuilder stringBuilder = new StringBuilder();
        for (String s : values) {
            stringBuilder.append("parameter=" + s + "&");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        this.testRequest(HttpMethod.GET, "/queryTests/arrayTests/formExploded?" + stringBuilder, 200, this.serializeInCSVStringArray(values));
    }

    @Test
    public void testQueryParameterArrayDefaultStyle() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/queryTests/arrayTests/default")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/queryTests/arrayTests/default", HttpMethod.GET, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            ArrayList<String> result = new ArrayList<String>();
            for (RequestParameter r : params.queryParameter("parameter").getArray()) {
                result.add(r.getInteger().toString());
            }
            routingContext.response().setStatusMessage(this.serializeInCSVStringArray(result)).end();
        }));
        ArrayList<String> values = new ArrayList<String>();
        values.add("4");
        values.add("2");
        values.add("26");
        this.testRequest(HttpMethod.GET, "/queryTests/arrayTests/default?parameter=" + this.serializeInCSVStringArray(values), 200, this.serializeInCSVStringArray(values));
    }

    @Test
    public void testQueryParameterArrayDefaultStyleFailure() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/queryTests/arrayTests/default")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/queryTests/arrayTests/default", HttpMethod.GET, true, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> routingContext.response().setStatusMessage("ok").end()));
        ArrayList<String> values = new ArrayList<String>();
        values.add("4");
        values.add("1");
        values.add("26");
        this.testRequest(HttpMethod.GET, "/queryTests/arrayTests/default?parameter=" + this.serializeInCSVStringArray(values), 400, this.errorMessage(ValidationException.ErrorType.NO_MATCH));
    }

    @Test
    public void testDefaultStringQueryParameter() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/queryTests/defaultString")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/queryTests/defaultString", HttpMethod.GET, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.queryParameter("parameter").getString()).end();
        }));
        this.testRequest(HttpMethod.GET, "/queryTests/defaultString", 200, "aString");
    }

    @Test
    public void testAllowEmptyValueQueryParameter() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/queryTests/defaultString")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/queryTests/defaultString", HttpMethod.GET, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.queryParameter("parameter").getString()).end();
        }));
        this.testRequest(HttpMethod.GET, "/queryTests/defaultString?parameter=", 200, "");
    }

    @Test
    public void testDefaultIntQueryParameter() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/queryTests/defaultInt")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/queryTests/defaultInt", HttpMethod.GET, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            RequestParameter requestParameter = params.queryParameter("parameter");
            this.assertTrue(requestParameter.isInteger());
            routingContext.response().setStatusMessage(requestParameter.toString()).end();
        }));
        this.testRequest(HttpMethod.GET, "/queryTests/defaultInt", 200, "1");
    }

    @Test
    public void testDefaultFloatQueryParameter() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/queryTests/defaultFloat")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/queryTests/defaultFloat", HttpMethod.GET, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            RequestParameter requestParameter = params.queryParameter("parameter");
            this.assertTrue(requestParameter.isFloat());
            routingContext.response().setStatusMessage(requestParameter.toString()).end();
        }));
        this.testRequest(HttpMethod.GET, "/queryTests/defaultFloat", 200, "1.0");
    }

    @Test
    public void testDefaultDoubleQueryParameter() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/queryTests/defaultDouble")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/queryTests/defaultDouble", HttpMethod.GET, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            RequestParameter requestParameter = params.queryParameter("parameter");
            this.assertTrue(requestParameter.isDouble());
            routingContext.response().setStatusMessage(requestParameter.toString()).end();
        }));
        this.testRequest(HttpMethod.GET, "/queryTests/defaultDouble", 200, "1.0");
    }

    @Test
    public void testQueryParameterByteFormat() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/queryTests/byteFormat")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/queryTests/byteFormat", HttpMethod.GET, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.queryParameter("parameter").getString()).end();
        }));
        this.testRequest(HttpMethod.GET, "/queryTests/byteFormat?parameter=Zm9vYmFyCg==", 200, "Zm9vYmFyCg==");
    }

    @Test
    public void testFormArrayParameter() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/formTests/arraytest")).getPost();
        if (op.getParameters() == null) {
            op.setParameters(new ArrayList());
        }
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/formTests/arraytest", HttpMethod.POST, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            ArrayList<String> result = new ArrayList<String>();
            for (RequestParameter r : params.formParameter("values").getArray()) {
                result.add(r.getInteger().toString());
            }
            routingContext.response().setStatusMessage(params.formParameter("id").getString() + this.serializeInCSVStringArray(result)).end();
        }));
        String id = "anId";
        ArrayList<String> valuesArray = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            valuesArray.add(this.getSuccessSample(ParameterType.INT).getInteger().toString());
        }
        String values = this.serializeInCSVStringArray(valuesArray);
        MultiMap form = MultiMap.caseInsensitiveMultiMap();
        form.add("id", id);
        form.add("values", values);
        this.testRequestWithForm(HttpMethod.POST, "/formTests/arraytest", ApiWebTestBase.FormType.FORM_URLENCODED, form, 200, id + values);
    }

    @Test
    public void testFormArrayParameterFailure() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/formTests/arraytest")).getPost();
        if (op.getParameters() == null) {
            op.setParameters(new ArrayList());
        }
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/formTests/arraytest", HttpMethod.POST, true, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> routingContext.response().setStatusMessage("ok").end()));
        String id = "anId";
        ArrayList<String> valuesArray = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            valuesArray.add(this.getSuccessSample(ParameterType.INT).getInteger().toString());
        }
        valuesArray.add(this.getFailureSample(ParameterType.INT));
        String values = this.serializeInCSVStringArray(valuesArray);
        MultiMap form = MultiMap.caseInsensitiveMultiMap();
        form.add("id", id);
        form.add("values", values);
        this.testRequestWithForm(HttpMethod.POST, "/formTests/arraytest", ApiWebTestBase.FormType.FORM_URLENCODED, form, 400, this.errorMessage(ValidationException.ErrorType.NO_MATCH));
    }

    @Test
    public void testFormURLEncodedCharParameter() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/formTests/urlencodedchar")).getPost();
        if (op.getParameters() == null) {
            op.setParameters(new ArrayList());
        }
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/formTests/urlencodedchar", HttpMethod.POST, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.formParameter("name").getString()).end();
        }));
        String name = "test+urlencoded+char";
        MultiMap form = MultiMap.caseInsensitiveMultiMap();
        form.add("name", name);
        this.testRequestWithForm(HttpMethod.POST, "/formTests/urlencodedchar", ApiWebTestBase.FormType.FORM_URLENCODED, form, 200, name);
    }

    @Test
    public void testJsonBody() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/jsonBodyTest/sampleTest")).getPost();
        if (op.getParameters() == null) {
            op.setParameters(new ArrayList());
        }
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/jsonBodyTest/sampleTest", HttpMethod.POST, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("Content-Type", "application/json").end(params.body().getJsonObject().encode());
        }));
        JsonObject object = new JsonObject();
        object.put("id", (Object)"anId");
        ArrayList<Integer> valuesArray = new ArrayList<Integer>();
        for (int i = 0; i < 4; ++i) {
            valuesArray.add(this.getSuccessSample(ParameterType.INT).getInteger());
        }
        object.put("values", valuesArray);
        this.testRequestWithJSON(HttpMethod.POST, "/jsonBodyTest/sampleTest", object.toBuffer(), 200, "OK", object.toBuffer());
        this.testRequestWithBufferResponse(HttpMethod.POST, "/jsonBodyTest/sampleTest", "application/json; charset=utf-8", object.toBuffer(), 200, "OK", "application/json", b -> this.assertEquals(object, b.toJsonObject()));
        this.testRequestWithBufferResponse(HttpMethod.POST, "/jsonBodyTest/sampleTest", "application/superapplication+json", object.toBuffer(), 200, "OK", "application/json", b -> this.assertEquals(object, b.toJsonObject()));
    }

    @Test
    public void testJsonBodyFailure() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/jsonBodyTest/sampleTest")).getPost();
        if (op.getParameters() == null) {
            op.setParameters(new ArrayList());
        }
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/jsonBodyTest/sampleTest", HttpMethod.POST, true, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("Content-Type", "application/json").end(params.body().getJsonObject().encode());
        }));
        JsonObject object = new JsonObject();
        object.put("id", (Object)"anId");
        ArrayList<String> valuesArray = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            valuesArray.add(this.getSuccessSample(ParameterType.INT).getInteger().toString());
        }
        valuesArray.add(2, this.getFailureSample(ParameterType.INT));
        object.put("values", valuesArray);
        this.testRequestWithJSON(HttpMethod.POST, "/jsonBodyTest/sampleTest", object.toBuffer(), 400, this.errorMessage(ValidationException.ErrorType.JSON_INVALID));
    }

    @Test
    public void testAllOfQueryParam() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/queryTests/allOfTest")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/queryTests/allOfTest", HttpMethod.GET, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.queryParameter("parameter").getObjectValue("a").getInteger().toString() + params.queryParameter("parameter").getObjectValue("b").getBoolean().toString()).end();
        }));
        String a = "5";
        String b = "false";
        String parameter = "parameter=a," + a + ",b," + b;
        this.testRequest(HttpMethod.GET, "/queryTests/allOfTest?" + parameter, 200, a + b);
    }

    @Test
    public void testAllOfQueryParamWithDefault() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/queryTests/allOfTest")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/queryTests/allOfTest", HttpMethod.GET, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.queryParameter("parameter").getObjectValue("a").getInteger().toString() + params.queryParameter("parameter").getObjectValue("b").getBoolean().toString()).end();
        }));
        String a = "5";
        String b = "";
        String parameter = "parameter=a," + a + ",b," + b;
        this.testRequest(HttpMethod.GET, "/queryTests/allOfTest?" + parameter, 200, a + "false");
    }

    @Test
    public void testAllOfQueryParamFailure() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/queryTests/allOfTest")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/queryTests/allOfTest", HttpMethod.GET, true, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> routingContext.response().setStatusMessage("ok").end()));
        String a = "5";
        String b = "aString";
        String parameter = "parameter=a," + a + ",b," + b;
        this.testRequest(HttpMethod.GET, "/queryTests/allOfTest?" + parameter, 400, this.errorMessage(ValidationException.ErrorType.NO_MATCH));
    }

    @Test
    public void testQueryParameterAnyOf() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/queryTests/anyOfTest")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/queryTests/anyOfTest", HttpMethod.GET, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusMessage(params.queryParameter("parameter").getBoolean().toString()).end();
        }));
        this.testRequest(HttpMethod.GET, "/queryTests/anyOfTest?parameter=true", 200, "true");
    }

    @Test
    public void testQueryParameterAnyOfFailure() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/queryTests/anyOfTest")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/queryTests/anyOfTest", HttpMethod.GET, true, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> routingContext.response().setStatusMessage("ok").end()));
        this.testRequest(HttpMethod.GET, "/queryTests/anyOfTest?parameter=anyString", 400, this.errorMessage(ValidationException.ErrorType.NO_MATCH));
    }

    @Test
    public void testComplexMultipart() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/multipart/complex")).getPost();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/multipart/complex", HttpMethod.POST, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            this.assertNotNull(params.formParameter("param2").getJsonObject());
            this.assertEquals("Willy", params.formParameter("param2").getJsonObject().getString("name"));
            this.assertEquals(4L, params.formParameter("param4").getArray().size());
            this.assertEquals(2, params.formParameter("param5").getInteger());
            routingContext.response().setStatusMessage("ok").end();
        }));
        JsonObject pet = new JsonObject();
        pet.put("id", (Object)14612);
        pet.put("name", (Object)"Willy");
        ArrayList<String> valuesArray = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            valuesArray.add(this.getSuccessSample(ParameterType.FLOAT).getFloat().toString());
        }
        MultipartForm form = MultipartForm.create().textFileUpload("param1", "random.txt", "src/test/resources/random.txt", "text/plain").attribute("param2", pet.encode()).textFileUpload("param3", "random.csv", "src/test/resources/random.txt", "text/csv").attribute("param4", this.serializeInCSVStringArray(valuesArray)).attribute("param5", "2").binaryFileUpload("param1Binary", "random-file", "src/test/resources/random-file", "text/plain");
        this.testRequestWithMultipartForm(HttpMethod.POST, "/multipart/complex", form, 200, "ok");
    }

    @Test
    public void testEmptyBody() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/multipart/complex/empty")).getPost();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/multipart/complex/empty", HttpMethod.POST, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> routingContext.response().setStatusMessage("ok").end()));
        this.testRequest(HttpMethod.POST, "/multipart/complex/empty", 200, "ok");
    }

    @Test
    @Ignore
    public void testCircularReferences() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/circularReferences")).getPost();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/circularReferences", HttpMethod.POST, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("Content-Type", "application/json").end(params.body().getJsonObject().encode());
        }));
        JsonObject obj = new JsonObject("{\n    \"a\": {\n        \"a\": [\n            {\n                \"a\": {\n                    \"a\": []\n                },\n                \"b\": \"hi\",\n                \"c\": 10\n            }\n        ]\n    },\n    \"b\": \"hello\",\n    \"c\": 6\n}");
        this.testRequestWithJSON(HttpMethod.POST, "/circularReferences", obj.toBuffer(), 200, "OK", obj.toBuffer());
    }

    @Test
    public void testNullJson() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/pets")).getPost();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/pets", HttpMethod.POST, true, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(params.body().getJsonObject().encode());
        }));
        this.testRequestWithJSON(HttpMethod.POST, "/pets", null, 400, this.errorMessage(ValidationException.ErrorType.JSON_NOT_PARSABLE));
        this.testRequestWithJSON(HttpMethod.POST, "/pets", new JsonObject().toBuffer(), 400, this.errorMessage(ValidationException.ErrorType.JSON_INVALID));
    }

    @Test
    public void testEmptyParametersNotNull() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/pets")).getPost();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/pets", HttpMethod.POST, true, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            this.assertEquals(0L, params.cookieParametersNames().size());
            this.assertEquals(0L, params.pathParametersNames().size());
            this.assertEquals(0L, params.queryParametersNames().size());
            this.assertEquals(0L, params.headerParametersNames().size());
            this.assertEquals(0L, params.formParametersNames().size());
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end();
        }));
        this.testRequestWithJSON(HttpMethod.POST, "/pets", new JsonObject().put("id", (Object)1).put("name", (Object)"Willy").toBuffer(), 200, "OK");
    }

    @Test
    public void testAdditionalPropertiesJson() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/additionalProperties")).getPost();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/additionalProperties", HttpMethod.POST, true, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(params.body().getJsonObject().encode());
        }));
        JsonObject pet = new JsonObject();
        pet.put("id", (Object)14612);
        pet.put("name", (Object)"Willy");
        pet.put("lazyness", (Object)"Highest");
        this.testRequestWithJSON(HttpMethod.POST, "/additionalProperties", pet.toBuffer(), 400, this.errorMessage(ValidationException.ErrorType.JSON_INVALID));
    }

    @Test
    public void testJsonBodyFailureErrorMessage() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/jsonBodyTest/sampleTest")).getPost();
        if (op.getParameters() == null) {
            op.setParameters(new ArrayList());
        }
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/jsonBodyTest/sampleTest", HttpMethod.POST, true, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("Content-Type", "application/json").end(params.body().getJsonObject().encode());
        }), (Handler<RoutingContext>)((Handler)routingContext -> {
            ValidationException e = (ValidationException)routingContext.failure();
            routingContext.response().setStatusCode(400).setStatusMessage(this.errorMessage(ValidationException.ErrorType.JSON_INVALID)).putHeader("Content-Type", "application/json").end(new JsonObject().put("field", (Object)e.parameterName()).toBuffer());
        }));
        JsonObject object = new JsonObject();
        object.put("id", (Object)"anId");
        ArrayList<String> valuesArray = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            valuesArray.add(this.getSuccessSample(ParameterType.INT).getInteger().toString());
        }
        valuesArray.add(0, this.getFailureSample(ParameterType.INT));
        object.put("values", valuesArray);
        this.testRequestWithJSON(HttpMethod.POST, "/jsonBodyTest/sampleTest", object.toBuffer(), 400, this.errorMessage(ValidationException.ErrorType.JSON_INVALID), new JsonObject().put("field", (Object)"body.values[0]").toBuffer());
        this.testRequestWithJSON(HttpMethod.POST, "/jsonBodyTest/sampleTest", new JsonArray().toBuffer(), 400, this.errorMessage(ValidationException.ErrorType.JSON_INVALID), new JsonObject().put("field", (Object)"body").toBuffer());
    }

    @Test
    public void testQueryExpandedObjectTestOnlyAdditionalProperties() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/queryTests/objectTests/onlyAdditionalProperties")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/queryTests/objectTests/onlyAdditionalProperties", HttpMethod.GET, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            this.assertEquals("hello", params.queryParameter("wellKnownParam").getString());
            RequestParameter param = params.queryParameter("params");
            this.assertFalse(param.getObjectKeys().contains("wellKnownParam"));
            int res = param.getObjectValue("param2").getInteger() + param.getObjectValue("param1").getInteger();
            routingContext.response().setStatusCode(200).setStatusMessage("Result: " + res).end();
        }));
        this.testRequest(HttpMethod.GET, "/queryTests/objectTests/onlyAdditionalProperties?param1=2&param2=4&wellKnownParam=hello", 200, "Result: 6");
    }

    @Test
    public void testQueryExpandedObjectTestOnlyAdditionalPropertiesFailure() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/queryTests/objectTests/onlyAdditionalProperties")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/queryTests/objectTests/onlyAdditionalProperties", HttpMethod.GET, true, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> routingContext.response().setStatusCode(200).setStatusMessage("OK").end()));
        this.testRequest(HttpMethod.GET, "/queryTests/objectTests/onlyAdditionalProperties?param1=2&param2=a&wellKnownParam=a", 400, this.errorMessage(ValidationException.ErrorType.NO_MATCH));
    }

    @Test
    public void testCookieExpandedObjectTestOnlyAdditionalProperties() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/cookieTests/objectTests/onlyAdditionalProperties")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/cookieTests/objectTests/onlyAdditionalProperties", HttpMethod.GET, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            this.assertEquals("hello", params.cookieParameter("wellKnownParam").toString());
            RequestParameter param = params.cookieParameter("params");
            this.assertFalse(param.getObjectKeys().contains("wellKnownParam"));
            int res = param.getObjectValue("param2").getInteger() + param.getObjectValue("param1").getInteger();
            routingContext.response().setStatusCode(200).setStatusMessage(Integer.toString(res)).end();
        }));
        QueryStringEncoder params = new QueryStringEncoder("/");
        params.addParam("param1", Integer.toString(5));
        params.addParam("param2", Integer.toString(1));
        params.addParam("wellKnownParam", "hello");
        this.testRequestWithCookies(HttpMethod.GET, "/cookieTests/objectTests/onlyAdditionalProperties", params.toUri().getRawQuery(), 200, "6");
    }

    @Test
    public void testCookieExpandedObjectTestOnlyAdditionalPropertiesFailure() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/cookieTests/objectTests/onlyAdditionalProperties")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/cookieTests/objectTests/onlyAdditionalProperties", HttpMethod.GET, true, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> routingContext.response().setStatusCode(200).setStatusMessage("OK").end()));
        QueryStringEncoder params = new QueryStringEncoder("/");
        params.addParam("param1", Integer.toString(5));
        params.addParam("param2", "a");
        params.addParam("wellKnownParam", "hello");
        this.testRequestWithCookies(HttpMethod.GET, "/cookieTests/objectTests/onlyAdditionalProperties", params.toUri().getRawQuery(), 400, this.errorMessage(ValidationException.ErrorType.NO_MATCH));
    }

    @Test
    public void testJsonBodyWithDate() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/jsonBodyWithDate")).getPost();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/jsonBodyWithDate", HttpMethod.POST, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("Content-Type", "application/json").end(params.body().getJsonObject().encode());
        }));
        JsonObject obj = new JsonObject();
        obj.put("date", (Object)"2018-02-18");
        obj.put("dateTime1", (Object)"2018-01-01T10:00:00.0000000000000000000000Z");
        obj.put("dateTime2", (Object)"2018-01-01T10:00:00+10:00");
        obj.put("dateTime3", (Object)"2018-01-01T10:00:00-10:00");
        this.testRequestWithJSON(HttpMethod.POST, "/jsonBodyWithDate", obj.toBuffer(), 200, "OK", obj.toBuffer());
    }

    @Test
    public void testQueryOptionalFormExplodeObject() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/query/form/explode/object")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/query/form/explode/object", HttpMethod.GET, false, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            RequestParameter colorQueryParam = params.queryParameter("color");
            this.assertNotNull(colorQueryParam);
            this.assertTrue(colorQueryParam.isObject());
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json").end(((JsonObject)colorQueryParam.toJson()).encode());
        }));
        String requestURI = "/query/form/explode/object?R=100&G=200&B=150&alpha=50";
        this.testEmptyRequestWithJSONObjectResponse(HttpMethod.GET, requestURI, 200, "OK", new JsonObject("{\"R\":\"100\",\"G\":\"200\",\"B\":\"150\",\"alpha\":50}"));
    }

    @Test
    public void testQueryOptionalFormExplodeObjectFailure() throws Exception {
        Operation op = ((PathItem)this.testSpec.getPaths().get((Object)"/query/form/explode/object")).getGet();
        OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(op, op.getParameters(), this.testSpec, this.refsCache);
        this.loadHandlers("/query/form/explode/object", HttpMethod.GET, true, (ValidationHandler)validationHandler, (Handler<RoutingContext>)((Handler)routingContext -> {
            RequestParameters params = (RequestParameters)routingContext.get("parsedParameters");
            RequestParameter colorQueryParam = params.queryParameter("color");
            this.assertNotNull(colorQueryParam);
            this.assertTrue(colorQueryParam.isObject());
            routingContext.response().setStatusCode(200).setStatusMessage("OK").putHeader("content-type", "application/json").end(((JsonObject)colorQueryParam.toJson()).encode());
        }));
        String requestURI = "/query/form/explode/object?R=100&G=200&B=150&alpha=aaa";
        this.testRequest(HttpMethod.GET, requestURI, 400, this.errorMessage(ValidationException.ErrorType.NO_MATCH));
    }
}

