/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.multipart.MultipartForm;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class ApiWebTestBase
extends WebTestBase {
    public WebClient webClient;

    public void setUp() throws Exception {
        super.setUp();
        this.webClient = WebClient.wrap((HttpClient)this.client, (WebClientOptions)new WebClientOptions().setConnectTimeout(Integer.MAX_VALUE).setIdleTimeout(Integer.MAX_VALUE).setIdleTimeoutUnit(TimeUnit.MILLISECONDS));
    }

    public void tearDown() throws Exception {
        if (this.webClient != null) {
            try {
                this.webClient.close();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        super.tearDown();
    }

    public void testRequestWithBufferResponse(HttpMethod method, String path, String contentType, Buffer obj, int statusCode, String statusMessage, String expectedContentType, Consumer<Buffer> checkResult) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        RequestOptions options = new RequestOptions().setMethod(method).setPort(Integer.valueOf(8080)).setHost("localhost").setURI(path);
        if (contentType != null) {
            options.addHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
        }
        this.client.request(options, this.onSuccess(req -> {
            Future fut = obj != null ? req.send(obj) : req.send();
            fut.onComplete(this.onSuccess(res -> {
                if (checkResult != null) {
                    this.assertEquals(statusCode, res.statusCode());
                    this.assertEquals(statusMessage, res.statusMessage());
                    this.assertEquals(expectedContentType, res.getHeader(HttpHeaders.CONTENT_TYPE));
                    res.body(this.onSuccess(buff -> {
                        buff = ApiWebTestBase.normalizeLineEndingsFor((Buffer)buff);
                        checkResult.accept((Buffer)buff);
                        latch.countDown();
                    }));
                } else {
                    this.assertEquals(statusCode, res.statusCode());
                    this.assertEquals(statusMessage, res.statusMessage());
                    latch.countDown();
                }
            }));
        }));
        this.awaitLatch(latch);
    }

    public void testRequestWithJSON(HttpMethod method, String path, Buffer obj, int statusCode, String statusMessage) throws Exception {
        this.testRequestWithJSON(method, path, obj, statusCode, statusMessage, null);
    }

    public void testRequestWithJSON(HttpMethod method, String path, Buffer obj, int statusCode, String statusMessage, Buffer expected) throws Exception {
        this.testRequestWithBufferResponse(method, path, "application/json", obj, statusCode, statusMessage, "application/json", expected != null ? b -> this.assertEquals(expected, b) : null);
    }

    public void testEmptyRequestWithJSONObjectResponse(HttpMethod method, String path, int statusCode, String statusMessage, JsonObject expected) throws Exception {
        this.testRequestWithBufferResponse(method, path, null, null, statusCode, statusMessage, "application/json", b -> this.assertEquals(expected, b.toJsonObject()));
    }

    public void testRequestWithForm(HttpMethod method, String path, FormType formType, MultiMap formMap, int statusCode, String statusMessage) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        HttpRequest request = this.webClient.request(method, 8080, "localhost", path);
        request.putHeader("Content-Type", formType.headerValue).sendForm(formMap, ar -> {
            this.assertEquals(statusCode, ((HttpResponse)ar.result()).statusCode());
            this.assertEquals(statusMessage, ((HttpResponse)ar.result()).statusMessage());
            latch.countDown();
        });
        this.awaitLatch(latch);
    }

    public void testRequestWithMultipartForm(HttpMethod method, String path, MultipartForm formMap, int statusCode, String statusMessage) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        HttpRequest request = this.webClient.request(method, 8080, "localhost", path);
        request.sendMultipartForm(formMap, ar -> {
            if (ar.failed()) {
                this.fail(ar.cause());
            }
            this.assertEquals(statusCode, ((HttpResponse)ar.result()).statusCode());
            this.assertEquals(statusMessage, ((HttpResponse)ar.result()).statusMessage());
            latch.countDown();
        });
        this.awaitLatch(latch);
    }

    public void testRequestWithResponseContentTypeCheck(HttpMethod method, String path, int statusCode, String contentType, List<String> acceptableContentTypes) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.client.request(method, 8080, "localhost", path, this.onSuccess(req -> req.putHeader("Accept", String.join((CharSequence)", ", acceptableContentTypes)).send(this.onSuccess(res -> {
            this.assertEquals(statusCode, res.statusCode());
            this.assertEquals(contentType, res.getHeader(HttpHeaders.CONTENT_TYPE));
            latch.countDown();
        }))));
        this.awaitLatch(latch);
    }

    public static enum FormType {
        MULTIPART("multipart/form-data"),
        FORM_URLENCODED("application/x-www-form-urlencoded");

        public String headerValue;

        private FormType(String headerValue) {
            this.headerValue = headerValue;
        }
    }
}

